/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.shiro.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCacheManager
implements CacheManager {
    private RedisTemplate<Object, Object> redisTemplate;

    public RedisCacheManager() {
    }

    public RedisCacheManager(RedisTemplate<Object, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        return new ShiroCache(name, this.redisTemplate);
    }

    public RedisTemplate<Object, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<Object, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public class ShiroCache<K, V>
    implements Cache<K, V> {
        private static final String REDIS_SHIRO_CACHE = "weiyou-shiro-cache:";
        private String cacheKey;
        private RedisTemplate<K, V> redisTemplate;
        private long globExpire = 30L;

        public RedisTemplate<K, V> getRedisTemplate() {
            return this.redisTemplate;
        }

        public void setRedisTemplate(RedisTemplate<K, V> redisTemplate) {
            this.redisTemplate = redisTemplate;
        }

        public ShiroCache(String name, RedisTemplate client) {
            this.cacheKey = REDIS_SHIRO_CACHE + name + ":";
            this.redisTemplate = client;
        }

        public V get(K key) throws CacheException {
            this.redisTemplate.boundValueOps(this.getCacheKey(key)).expire(this.globExpire, TimeUnit.MINUTES);
            return (V)this.redisTemplate.boundValueOps(this.getCacheKey(key)).get();
        }

        public V put(K key, V value) throws CacheException {
            V old = this.get(key);
            this.redisTemplate.boundValueOps(this.getCacheKey(key)).set(value);
            return old;
        }

        public V remove(K key) throws CacheException {
            V old = this.get(key);
            this.redisTemplate.delete(this.getCacheKey(key));
            return old;
        }

        public void clear() throws CacheException {
            this.redisTemplate.delete(this.keys());
        }

        public int size() {
            return this.keys().size();
        }

        public Set<K> keys() {
            return this.redisTemplate.keys(this.getCacheKey("*"));
        }

        public Collection<V> values() {
            Set<K> set = this.keys();
            ArrayList<V> list = new ArrayList<V>();
            for (K s : set) {
                list.add(this.get(s));
            }
            return list;
        }

        private K getCacheKey(Object k) {
            return (K)(this.cacheKey + k);
        }
    }
}

