/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.filter.base;

import com.ailikes.common.security.constant.SecurityConstant;
import com.ailikes.common.security.filter.base.SecurityFilter;
import com.ailikes.common.security.filter.base.SecurityHttpServletRequest;
import com.ailikes.common.security.filter.base.SecurityHttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class DefaultBaseSecurityFilter
implements Filter {
    private List<SecurityFilter> securityFilterList = new ArrayList<SecurityFilter>();

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            for (int i = 0; i < this.securityFilterList.size(); ++i) {
                this.securityFilterList.get(i).doFilterInvoke(httpRequest, httpResponse);
            }
            filterChain.doFilter((ServletRequest)new SecurityHttpServletRequest(httpRequest), (ServletResponse)new SecurityHttpServletResponse(httpResponse));
            return;
        }
        if (request instanceof MultipartHttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
            MultipartHttpServletRequest multiReq = multipartResolver.resolveMultipart(httpRequest);
            httpRequest = multiReq;
            for (int i = 0; i < this.securityFilterList.size(); ++i) {
                this.securityFilterList.get(i).doFilterInvoke(httpRequest, httpResponse);
            }
            filterChain.doFilter((ServletRequest)new SecurityHttpServletRequest(httpRequest), (ServletResponse)new SecurityHttpServletResponse(httpResponse));
            return;
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initCookieWhiteList(filterConfig);
        this.initWhitefilePostFixList(filterConfig);
        this.initOnlyPostUrlList(filterConfig);
        try {
            this.initSecurityFilterList(filterConfig);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void initCookieWhiteList(FilterConfig filterConfig) throws ServletException {
        String list = filterConfig.getInitParameter("cookieWhiteList");
        if (list == null || list.isEmpty()) {
            return;
        }
        String[] cookieList = list.split(",");
        SecurityConstant.cookieWhiteList.addAll(Arrays.asList(cookieList));
    }

    public void initWhitefilePostFixList(FilterConfig filterConfig) throws ServletException {
        String list = filterConfig.getInitParameter("whitefilePostFixList");
        if (list == null || list.isEmpty()) {
            return;
        }
        String[] cookieList = list.split(",");
        SecurityConstant.whitefilePostFixList.addAll(Arrays.asList(cookieList));
    }

    public void initOnlyPostUrlList(FilterConfig filterConfig) throws ServletException {
        String list = filterConfig.getInitParameter("onlyPostUrlList");
        if (list == null || list.isEmpty()) {
            return;
        }
        String[] onlyPostUrlList = list.split(",");
        SecurityConstant.onlyPostUrlList.addAll(Arrays.asList(onlyPostUrlList));
    }

    public void initRedictWhiteList(FilterConfig filterConfig) throws ServletException {
        String list = filterConfig.getInitParameter("redirectWhiteList");
        if (list == null || list.isEmpty()) {
            return;
        }
        String[] redirectWhiteList = list.split(",");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String str : redirectWhiteList) {
            patterns.add(Pattern.compile(str));
        }
        SecurityConstant.redirectLocationWhiteList.addAll(patterns);
    }

    private void initSecurityFilterList(FilterConfig filterConfig) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String[] filterList;
        String securityFilterS = filterConfig.getInitParameter("securityFilterList");
        if (securityFilterS == null || securityFilterS.isEmpty()) {
            return;
        }
        for (String filter : filterList = securityFilterS.split(",")) {
            Class<?> securityFilter = Class.forName(filter);
            SecurityFilter securityFilterInstance = (SecurityFilter)securityFilter.newInstance();
            this.securityFilterList.add(securityFilterInstance);
        }
    }
}

