/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.filter;

import com.ailikes.common.security.constant.SecurityConstant;
import com.ailikes.common.security.filter.base.SecurityFilter;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class CookieWhiteListFilter
implements SecurityFilter {
    @Override
    public void doFilterInvoke(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request = new CookieWhiteFilterHttpServletRequest((HttpServletRequest)request);
    }

    private Cookie[] filter(Cookie[] cookies) {
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (!this.isInWhiteList(cookie)) continue;
            cookieList.add(cookie);
        }
        return cookieList.toArray(new Cookie[cookieList.size()]);
    }

    private boolean isInWhiteList(Cookie cookie) {
        if (cookie == null || cookie.getName() == null) {
            return false;
        }
        for (String name : SecurityConstant.cookieWhiteList) {
            if (!name.equalsIgnoreCase(cookie.getName())) continue;
            return true;
        }
        return false;
    }

    public class CookieWhiteFilterHttpServletRequest
    extends HttpServletRequestWrapper {
        public CookieWhiteFilterHttpServletRequest(HttpServletRequest request) {
            super(request);
        }

        public Cookie[] getCookies() {
            return CookieWhiteListFilter.this.filter(super.getCookies());
        }
    }
}

