/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.shiro.interceptor;

import com.ailikes.common.security.shiro.authz.annotation.RequiresMethodPermissions;
import com.ailikes.common.security.shiro.authz.annotation.RequiresPathPermission;
import com.ailikes.common.utils.StringUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.subject.Subject;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class PermissionInterceptorAdapter
extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        RequiresMethodPermissions requiresMethodPermissions;
        if (handler instanceof HandlerMethod && (requiresMethodPermissions = (RequiresMethodPermissions)(handlerMethod = (HandlerMethod)handler).getMethodAnnotation(RequiresMethodPermissions.class)) != null) {
            String[] perms;
            RequiresPathPermission requiresPathPermission = (RequiresPathPermission)AnnotationUtils.findAnnotation(handlerMethod.getBean().getClass(), RequiresPathPermission.class);
            String basePermission = "";
            if (requiresPathPermission != null) {
                basePermission = requiresPathPermission.value();
            }
            if ((perms = requiresMethodPermissions.value()).length == 1) {
                String permission = perms[0];
                if (!StringUtils.isEmpty((String)basePermission)) {
                    permission = basePermission + ":" + perms[0];
                }
                this.getSubject().checkPermission(permission);
                return true;
            }
            if (Logical.AND.equals((Object)requiresMethodPermissions.logical())) {
                String[] newPerms = new String[perms.length];
                for (int i = 0; i < perms.length; ++i) {
                    String perm = perms[i];
                    if (!StringUtils.isEmpty((String)basePermission)) {
                        perm = basePermission + ":" + perm;
                    }
                    newPerms[i] = perm;
                }
                this.getSubject().checkPermissions(newPerms);
                return true;
            }
            if (Logical.OR.equals((Object)requiresMethodPermissions.logical())) {
                boolean hasAtLeastOnePermission = false;
                for (String permission : perms) {
                    if (!StringUtils.isEmpty((String)basePermission)) {
                        permission = basePermission + ":" + permission;
                    }
                    if (!this.getSubject().isPermitted(permission)) continue;
                    hasAtLeastOnePermission = true;
                }
                if (!hasAtLeastOnePermission) {
                    String permission = perms[0];
                    if (!StringUtils.isEmpty((String)basePermission)) {
                        permission = basePermission + ":" + permission;
                    }
                    this.getSubject().checkPermission(permission);
                }
                return true;
            }
        }
        return true;
    }

    protected Subject getSubject() {
        return SecurityUtils.getSubject();
    }
}

