/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.filter;

import com.ailikes.common.security.constant.SecurityConstant;
import com.ailikes.common.security.filter.base.SecurityFilter;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FormPostPermitCheckFilter
implements SecurityFilter {
    @Override
    public void doFilterInvoke(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.Valid(request.getRequestURI(), request.getMethod())) {
            throw new RuntimeException("this requestUrI : " + request.getRequestURI() + " only permit post, but now is " + request.getMethod());
        }
    }

    private boolean Valid(String requestURI, String method) {
        if (!"POST".equalsIgnoreCase(method)) {
            for (String patternUri : SecurityConstant.onlyPostUrlList) {
                if (!Pattern.matches(patternUri, requestURI)) continue;
                return false;
            }
        }
        return true;
    }
}

