/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.shiro.session;

import com.ailikes.common.security.shiro.session.SessionDAO;
import com.ailikes.common.utils.DateUtils;
import com.ailikes.common.utils.ServletUtils;
import com.ailikes.common.utils.StringUtils;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisSessionDAO
extends AbstractSessionDAO
implements SessionDAO {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String sessionKeyPrefix = "gzskjt_session_";
    private RedisTemplate<Object, Object> redisTemplate;

    public RedisSessionDAO() {
    }

    public RedisSessionDAO(RedisTemplate<Object, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void update(Session session) throws UnknownSessionException {
        if (session == null || session.getId() == null) {
            return;
        }
        HttpServletRequest request = ServletUtils.getRequest();
        try {
            PrincipalCollection pc = (PrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
            String principalId = pc != null ? pc.getPrimaryPrincipal().toString() : "";
            this.redisTemplate.opsForHash().put((Object)this.sessionKeyPrefix, (Object)session.getId().toString(), (Object)(principalId + "|" + session.getTimeout() + "|" + session.getLastAccessTime().getTime()));
            this.redisTemplate.opsForValue().set((Object)(this.sessionKeyPrefix + session.getId()), (Object)session);
            int timeoutSeconds = (int)(session.getTimeout() / 1000L);
            this.redisTemplate.expire((Object)(this.sessionKeyPrefix + session.getId()), (long)timeoutSeconds, TimeUnit.SECONDS);
            this.redisTemplate.expire((Object)this.sessionKeyPrefix, (long)timeoutSeconds, TimeUnit.SECONDS);
            this.logger.debug("update {} {}", (Object)session.getId(), (Object)(request != null ? request.getRequestURI() : ""));
        }
        catch (Exception e) {
            this.logger.error("update {} {}", new Object[]{session.getId(), request != null ? request.getRequestURI() : "", e});
        }
    }

    public void delete(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        try {
            this.redisTemplate.opsForHash().delete((Object)this.sessionKeyPrefix, new Object[]{session.getId().toString()});
            this.redisTemplate.delete((Object)(this.sessionKeyPrefix + session.getId()));
            this.logger.debug("delete {} ", (Object)session.getId());
        }
        catch (Exception e) {
            this.logger.error("delete {} ", (Object)session.getId(), (Object)e);
        }
    }

    public Collection<Session> getActiveSessions() {
        return this.getActiveSessions(true);
    }

    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave) {
        return this.getActiveSessions(includeLeave, null, null);
    }

    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave, Object principal, Session filterSession) {
        HashSet sessions = Sets.newHashSet();
        try {
            Map map = this.redisTemplate.opsForHash().entries((Object)this.sessionKeyPrefix);
            for (Map.Entry e : map.entrySet()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
                    String[] ss = StringUtils.split((String)value, (String)"|");
                    if (ss != null && ss.length == 3) {
                        SimpleSession session = (SimpleSession)this.redisTemplate.opsForValue().get((Object)(this.sessionKeyPrefix + key));
                        session.setId((Serializable)((Object)key));
                        session.setAttribute((Object)"principalId", (Object)ss[0]);
                        session.setTimeout(Long.valueOf(ss[1]).longValue());
                        session.setLastAccessTime(new Date(Long.valueOf(ss[2])));
                        try {
                            session.validate();
                            boolean isActiveSession = false;
                            if (includeLeave || DateUtils.pastMinutes((Date)session.getLastAccessTime()) <= 3L) {
                                isActiveSession = true;
                            }
                            if (principal != null) {
                                PrincipalCollection pc = (PrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                                if (principal.toString().equals(pc != null ? pc.getPrimaryPrincipal().toString() : "")) {
                                    isActiveSession = true;
                                }
                            }
                            if (filterSession != null && filterSession.getId().equals(session.getId())) {
                                isActiveSession = false;
                            }
                            if (!isActiveSession) continue;
                            sessions.add(session);
                        }
                        catch (Exception e2) {
                            this.redisTemplate.opsForHash().delete((Object)this.sessionKeyPrefix, new Object[]{e.getKey()});
                        }
                        continue;
                    }
                    this.redisTemplate.opsForHash().delete((Object)this.sessionKeyPrefix, new Object[]{e.getKey()});
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                this.redisTemplate.opsForHash().delete((Object)this.sessionKeyPrefix, new Object[]{key});
            }
            this.logger.info("getActiveSessions size: {} ", (Object)sessions.size());
        }
        catch (Exception e) {
            this.logger.error("getActiveSessions", (Throwable)e);
        }
        return sessions;
    }

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.update(session);
        return sessionId;
    }

    protected Session doReadSession(Serializable sessionId) {
        Session s = null;
        HttpServletRequest request = ServletUtils.getRequest();
        if (request != null) {
            s = (Session)request.getAttribute("session_" + sessionId);
        }
        if (s != null) {
            return s;
        }
        Session session = null;
        try {
            session = (Session)this.redisTemplate.opsForValue().get((Object)(this.sessionKeyPrefix + sessionId));
            this.logger.debug("doReadSession {} {}", (Object)sessionId, (Object)(request != null ? request.getRequestURI() : ""));
        }
        catch (Exception e) {
            this.logger.error("doReadSession {} {}", new Object[]{sessionId, request != null ? request.getRequestURI() : "", e});
        }
        if (request != null && session != null) {
            request.setAttribute("session_" + sessionId, (Object)session);
        }
        return session;
    }

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        try {
            return super.readSession(sessionId);
        }
        catch (UnknownSessionException e) {
            return null;
        }
    }

    public RedisTemplate<Object, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<Object, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String getSessionKeyPrefix() {
        return this.sessionKeyPrefix;
    }

    public void setSessionKeyPrefix(String sessionKeyPrefix) {
        this.sessionKeyPrefix = sessionKeyPrefix;
    }
}

