/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.shiro.session;

import com.ailikes.common.security.shiro.session.SessionDAO;
import com.ailikes.common.utils.DateUtils;
import com.ailikes.common.utils.JedisUtils;
import com.ailikes.common.utils.ServletUtils;
import com.ailikes.common.utils.StringUtils;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class JedisSessionDAO
extends AbstractSessionDAO
implements SessionDAO {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String sessionKeyPrefix = "gzskjt_session_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Session session) throws UnknownSessionException {
        if (session == null || session.getId() == null) {
            return;
        }
        HttpServletRequest request = ServletUtils.getRequest();
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            PrincipalCollection pc = (PrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
            String principalId = pc != null ? pc.getPrimaryPrincipal().toString() : "";
            jedis.hset(this.sessionKeyPrefix, session.getId().toString(), principalId + "|" + session.getTimeout() + "|" + session.getLastAccessTime().getTime());
            jedis.set(JedisUtils.getBytesKey((Object)(this.sessionKeyPrefix + session.getId())), JedisUtils.toBytes((Object)session));
            int timeoutSeconds = (int)(session.getTimeout() / 1000L);
            jedis.expire(this.sessionKeyPrefix + session.getId(), timeoutSeconds);
            this.logger.debug("update {} {}", (Object)session.getId(), (Object)(request != null ? request.getRequestURI() : ""));
        }
        catch (Exception e) {
            this.logger.error("update {} {}", new Object[]{session.getId(), request != null ? request.getRequestURI() : "", e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            jedis.hdel(JedisUtils.getBytesKey((Object)this.sessionKeyPrefix), (byte[][])new byte[][]{JedisUtils.getBytesKey((Object)session.getId().toString())});
            jedis.del(JedisUtils.getBytesKey((Object)(this.sessionKeyPrefix + session.getId())));
            this.logger.debug("delete {} ", (Object)session.getId());
        }
        catch (Exception e) {
            this.logger.error("delete {} ", (Object)session.getId(), (Object)e);
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
    }

    public Collection<Session> getActiveSessions() {
        return this.getActiveSessions(true);
    }

    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave) {
        return this.getActiveSessions(includeLeave, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave, Object principal, Session filterSession) {
        HashSet sessions = Sets.newHashSet();
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            Map map = jedis.hgetAll(this.sessionKeyPrefix);
            for (Map.Entry e : map.entrySet()) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)e.getKey())) && StringUtils.isNotBlank((CharSequence)((CharSequence)e.getValue()))) {
                    String[] ss = StringUtils.split((String)((String)e.getValue()), (String)"|");
                    if (ss != null && ss.length == 3) {
                        SimpleSession session = new SimpleSession();
                        session.setId((Serializable)e.getKey());
                        session.setAttribute((Object)"principalId", (Object)ss[0]);
                        session.setTimeout(Long.valueOf(ss[1]).longValue());
                        session.setLastAccessTime(new Date(Long.valueOf(ss[2])));
                        try {
                            session.validate();
                            boolean isActiveSession = false;
                            if (includeLeave || DateUtils.pastMinutes((Date)session.getLastAccessTime()) <= 3L) {
                                isActiveSession = true;
                            }
                            if (principal != null) {
                                PrincipalCollection pc = (PrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                                if (principal.toString().equals(pc != null ? pc.getPrimaryPrincipal().toString() : "")) {
                                    isActiveSession = true;
                                }
                            }
                            if (filterSession != null && filterSession.getId().equals(session.getId())) {
                                isActiveSession = false;
                            }
                            if (!isActiveSession) continue;
                            sessions.add(session);
                        }
                        catch (Exception e2) {
                            jedis.hdel(this.sessionKeyPrefix, new String[]{(String)e.getKey()});
                        }
                        continue;
                    }
                    jedis.hdel(this.sessionKeyPrefix, new String[]{(String)e.getKey()});
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)e.getKey()))) continue;
                jedis.hdel(this.sessionKeyPrefix, new String[]{(String)e.getKey()});
            }
            this.logger.info("getActiveSessions size: {} ", (Object)sessions.size());
        }
        catch (Exception e) {
            this.logger.error("getActiveSessions", (Throwable)e);
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        return sessions;
    }

    protected Serializable doCreate(Session session) {
        HttpServletRequest request = ServletUtils.getRequest();
        if (request != null) {
            String string = request.getServletPath();
        }
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.update(session);
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session doReadSession(Serializable sessionId) {
        Session s = null;
        HttpServletRequest request = ServletUtils.getRequest();
        if (request != null) {
            String uri = request.getServletPath();
            s = (Session)request.getAttribute("session_" + sessionId);
        }
        if (s != null) {
            return s;
        }
        Session session = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            session = (Session)JedisUtils.toObject((byte[])jedis.get(JedisUtils.getBytesKey((Object)(this.sessionKeyPrefix + sessionId))));
            this.logger.debug("doReadSession {} {}", (Object)sessionId, (Object)(request != null ? request.getRequestURI() : ""));
        }
        catch (Exception e) {
            this.logger.error("doReadSession {} {}", new Object[]{sessionId, request != null ? request.getRequestURI() : "", e});
        }
        finally {
            JedisUtils.returnResource((Jedis)jedis);
        }
        if (request != null && session != null) {
            request.setAttribute("session_" + sessionId, (Object)session);
        }
        return session;
    }

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        try {
            return super.readSession(sessionId);
        }
        catch (UnknownSessionException e) {
            return null;
        }
    }

    public String getSessionKeyPrefix() {
        return this.sessionKeyPrefix;
    }

    public void setSessionKeyPrefix(String sessionKeyPrefix) {
        this.sessionKeyPrefix = sessionKeyPrefix;
    }
}

