/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.filter.base;

import com.ailikes.common.security.constant.SecurityConstant;
import com.ailikes.common.security.utils.ResponseHeaderSecurityCheck;
import com.ailikes.common.security.utils.XssUtil;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class SecurityHttpServletResponse
extends HttpServletResponseWrapper {
    private static final int MAX_COOKIE_SIZE = 4096;
    private int length = 0;

    public SecurityHttpServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void addCookie(Cookie cookie) {
        if (this.length + cookie.getValue().length() > 4096) {
            return;
        }
        if (!this.isInWhiteList(cookie)) {
            throw new RuntimeException("cookie:" + cookie.getName() + " is not in whitelist,not valid.");
        }
        super.addCookie(ResponseHeaderSecurityCheck.checkCookie(cookie));
        this.length += cookie.getValue().length();
    }

    public void setDateHeader(String name, long date) {
        super.setDateHeader(ResponseHeaderSecurityCheck.filterCLRF(name), date);
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(ResponseHeaderSecurityCheck.filterCLRF(name), value);
    }

    public void addHeader(String name, String value) {
        super.addHeader(ResponseHeaderSecurityCheck.filterCLRF(name), XssUtil.xssFilter(ResponseHeaderSecurityCheck.filterCLRF(value), null));
    }

    public void setHeader(String name, String value) {
        super.setHeader(ResponseHeaderSecurityCheck.filterCLRF(name), XssUtil.xssFilter(ResponseHeaderSecurityCheck.filterCLRF(value), null));
    }

    public void sendRedirect(String location) throws IOException {
        if (!ResponseHeaderSecurityCheck.checkRedirectValid(location)) {
            throw new RuntimeException("redirect location " + location + " is not valid.");
        }
        super.sendRedirect(location);
    }

    public void setStatus(int sc, String sm) {
        super.setStatus(sc, XssUtil.xssFilter(sm, null));
    }

    private boolean isInWhiteList(Cookie cookie) {
        if (cookie == null || cookie.getName() == null) {
            return false;
        }
        for (String name : SecurityConstant.cookieWhiteList) {
            if (!name.equalsIgnoreCase(cookie.getName())) continue;
            return true;
        }
        return false;
    }
}

