/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.filter;

import com.ailikes.common.security.constant.SecurityConstant;
import com.ailikes.common.security.filter.base.SecurityFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

public class FileUploadSecurityFilter
implements SecurityFilter {
    @Override
    public void doFilterInvoke(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request = new UploadFileExtensionFilterHttpServletRequest((HttpServletRequest)request);
    }

    public class UploadFileExtensionFilterHttpServletRequest
    extends HttpServletRequestWrapper {
        public UploadFileExtensionFilterHttpServletRequest(HttpServletRequest request) {
            super(request);
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            Collection parts = super.getParts();
            if (parts == null || parts.isEmpty()) {
                return parts;
            }
            ArrayList<Part> resParts = new ArrayList<Part>();
            for (Part part : parts) {
                for (String extension : SecurityConstant.whitefilePostFixList) {
                    if (!part.getName().toUpperCase().endsWith(extension)) continue;
                    resParts.add(part);
                }
            }
            return resParts;
        }

        public Part getPart(String name) throws IOException, ServletException {
            Part part = super.getPart(name);
            for (String extension : SecurityConstant.whitefilePostFixList) {
                if (!part.getName().toUpperCase().endsWith(extension)) continue;
                return part;
            }
            return null;
        }
    }
}

