/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.query.resolver;

import com.ailikes.common.query.annotation.QueryableDefaults;
import com.ailikes.common.query.data.Pageable;
import com.ailikes.common.query.data.QueryRequest;
import com.ailikes.common.query.data.Queryable;
import com.ailikes.common.query.resolver.BaseMethodArgumentResolver;
import com.ailikes.common.query.resolver.PageableMethodArgumentResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class QueryMethodArgumentResolver
extends BaseMethodArgumentResolver {
    private static final PageableMethodArgumentResolver DEFAULT_PAGEABLE_RESOLVER = new PageableMethodArgumentResolver();
    private static final String DEFAULT_QUERY_PREFIX = "query";
    private String prefix = "query";
    private PageableMethodArgumentResolver pageableMethodArgumentResolver = DEFAULT_PAGEABLE_RESOLVER;

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPageableMethodArgumentResolver(PageableMethodArgumentResolver pageableMethodArgumentResolver) {
        this.pageableMethodArgumentResolver = pageableMethodArgumentResolver;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return Queryable.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String queryPrefix = this.getQueryPrefix(parameter);
        Map<String, String[]> queryeableMap = this.getPrefixParameterMap(queryPrefix, webRequest, true);
        boolean hasCustomQueryFilter = queryeableMap.size() > 0;
        QueryableDefaults queryDefaults = this.getQueryableDefaults(parameter);
        boolean needMergeDefault = queryDefaults != null && queryDefaults.merge();
        Queryable queryable = null;
        if (needMergeDefault || !hasCustomQueryFilter) {
            queryable = this.getDefaultFromAnnotation(queryDefaults);
        }
        if (queryable == null) {
            queryable = new QueryRequest();
        }
        if (hasCustomQueryFilter) {
            for (String name : queryeableMap.keySet()) {
                String[] mapValues = this.filterQueryValues(queryeableMap.get(name));
                if (mapValues.length == 1) {
                    if (name.endsWith("in") || name.endsWith("between")) {
                        queryable.addCondition(name, StringUtils.split((String)mapValues[0], (String)","));
                        continue;
                    }
                    queryable.addCondition(name, mapValues[0]);
                    continue;
                }
                queryable.addCondition(name, mapValues);
            }
        }
        Pageable pageable = (Pageable)this.pageableMethodArgumentResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        if (queryDefaults == null) {
            queryable.setPageable(pageable);
        }
        if (queryDefaults != null && queryDefaults.needPage()) {
            queryable.setPageable(pageable);
        }
        if (queryDefaults != null && !queryDefaults.needPage() && queryDefaults.needSort()) {
            queryable.addSort(pageable.getSort());
        }
        if (pageable.getSort() != null) {
            queryable.addSort(pageable.getSort());
        }
        return queryable;
    }

    private String[] filterQueryValues(String[] values) {
        ArrayList result = Lists.newArrayList((Object[])values);
        for (int i = 0; i < result.size(); ++i) {
            if (!StringUtils.isBlank((CharSequence)((CharSequence)result.get(i)))) continue;
            result.remove(i);
        }
        return result.toArray(values);
    }

    private String getQueryPrefix(MethodParameter parameter) {
        Qualifier qualifier = (Qualifier)parameter.getParameterAnnotation(Qualifier.class);
        if (qualifier != null) {
            return qualifier.value() + "_" + this.prefix;
        }
        return this.prefix;
    }

    private QueryableDefaults getQueryableDefaults(MethodParameter parameter) {
        QueryableDefaults queryDefaults = (QueryableDefaults)parameter.getParameterAnnotation(QueryableDefaults.class);
        if (queryDefaults == null) {
            queryDefaults = (QueryableDefaults)parameter.getMethodAnnotation(QueryableDefaults.class);
        }
        return queryDefaults;
    }

    private Queryable getDefaultFromAnnotation(QueryableDefaults queryableDefaults) {
        Queryable queryable = this.defaultQueryable(queryableDefaults);
        if (queryable != null) {
            return queryable;
        }
        return QueryRequest.newQueryable();
    }

    private Queryable defaultQueryable(QueryableDefaults queryableDefaults) {
        if (queryableDefaults == null) {
            return null;
        }
        Queryable queryable = QueryRequest.newQueryable();
        for (String queryParam : queryableDefaults.value()) {
            String[] queryPair = queryParam.split("=");
            String paramName = queryPair[0];
            String paramValue = queryPair[1];
            if (paramName.endsWith("in") || paramName.endsWith("between")) {
                queryable.addCondition(paramName, StringUtils.split((String)paramValue, (String)","));
                continue;
            }
            queryable.addCondition(paramName, paramValue);
        }
        return queryable;
    }
}

