/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.query.data;

import com.ailikes.common.query.data.Condition;
import com.ailikes.common.query.data.Pageable;
import com.ailikes.common.query.data.Queryable;
import com.ailikes.common.query.data.Sort;
import com.ailikes.common.query.exception.InvlidOperatorException;
import com.ailikes.common.query.exception.QueryException;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class QueryRequest
implements Queryable {
    private Pageable pageable;
    private Sort sort;
    private Condition condition;
    public static final String separator = "||";
    private boolean converted;

    public static Queryable newQueryable() {
        return new QueryRequest();
    }

    @Override
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public void addSort(Sort sort) {
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    @Override
    public Object getValue(String property) {
        if (this.getCondition() != null && this.getCondition().getFilterFor(property) != null) {
            return this.getCondition().getFilterFor(property).getValue();
        }
        return null;
    }

    @Override
    public Queryable addCondition(String property, Object value) {
        Assert.notNull((Object)property, (String)"Condition key must not null");
        String[] searchs = StringUtils.split((String)property, (String)separator);
        if (searchs.length == 0) {
            throw new QueryException("Condition key format must be : property or property_op");
        }
        property = searchs[0];
        Condition.Operator operator = null;
        if (searchs.length == 1) {
            operator = Condition.Operator.eq;
        } else {
            try {
                operator = Condition.Operator.fromString(searchs[1]);
            }
            catch (IllegalArgumentException e) {
                throw new InvlidOperatorException(property, searchs[1]);
            }
        }
        boolean allowBlankValue = Condition.Operator.isAllowBlankValue(operator);
        boolean isValueBlank = value == null;
        isValueBlank = isValueBlank || value instanceof String && StringUtils.isEmpty((Object)((String)value));
        boolean bl = isValueBlank = isValueBlank || value instanceof List && ((List)value).size() == 0;
        if (!allowBlankValue && isValueBlank) {
            return null;
        }
        if (this.condition == null) {
            Condition.Filter filter = new Condition.Filter(operator, property, value);
            this.condition = new Condition(filter);
        } else {
            this.condition.and(operator, property, value);
        }
        return this;
    }

    @Override
    public boolean isConverted() {
        return this.converted;
    }

    @Override
    public void removeCondition(String property) {
        this.getCondition().remove(property);
    }
}

