/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.query.utils;

import com.ailikes.common.query.data.Condition;
import com.ailikes.common.query.data.Queryable;
import com.ailikes.common.query.exception.QueryException;
import com.ailikes.common.utils.convert.DateConvertEditor;
import com.google.common.collect.Lists;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.CollectionUtils;

public final class QueryableConvertUtils {
    private static volatile ConversionService conversionService;

    public static void setConversionService(ConversionService conversionService) {
        QueryableConvertUtils.conversionService = conversionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConversionService getConversionService() {
        if (conversionService != null) return conversionService;
        Class<QueryableConvertUtils> clazz = QueryableConvertUtils.class;
        synchronized (QueryableConvertUtils.class) {
            if (conversionService != null) return conversionService;
            try {
                conversionService = new DefaultConversionService();
            }
            catch (Exception e) {
                throw new QueryException("conversionService is null, query param convert must use conversionService. please see [com.sishuok.es.common.entity.query.utils.QueryableConvertUtils#setConversionService]");
            }
            return conversionService;
        }
    }

    public static <T> void convertQueryValueToEntityValue(Queryable query, Class<T> entityClass) {
        if (query.isConverted()) {
            return;
        }
        Condition condition = query.getCondition();
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(entityClass);
        beanWrapper.setAutoGrowNestedPaths(true);
        beanWrapper.setConversionService(QueryableConvertUtils.getConversionService());
        beanWrapper.registerCustomEditor(Date.class, (PropertyEditor)new DateConvertEditor());
        if (condition != null) {
            for (Condition.Filter filter : condition) {
                QueryableConvertUtils.convert(beanWrapper, filter);
            }
        }
    }

    private static void convert(BeanWrapperImpl beanWrapper, Condition.Filter filter) {
        boolean isArray;
        String property = filter.getProperty();
        if (filter.getOperator() == Condition.Operator.custom) {
            return;
        }
        if (filter.isUnaryFilter()) {
            return;
        }
        Object value = filter.getValue();
        Object newValue = null;
        boolean isCollection = value instanceof Collection;
        boolean bl = isArray = value != null && value.getClass().isArray();
        if (isCollection || isArray) {
            ArrayList list = Lists.newArrayList();
            if (isCollection) {
                list.addAll((Collection)value);
            } else {
                list = Lists.newArrayList((Iterable)CollectionUtils.arrayToList((Object)value));
            }
            int length = list.size();
            for (int i = 0; i < length; ++i) {
                list.set(i, QueryableConvertUtils.getConvertedValue(beanWrapper, property, list.get(i)));
            }
            newValue = list;
        } else {
            newValue = QueryableConvertUtils.getConvertedValue(beanWrapper, property, value);
        }
        filter.setValue(newValue);
    }

    private static Object getConvertedValue(BeanWrapperImpl beanWrapper, String property, Object value) {
        Object newValue;
        try {
            beanWrapper.setPropertyValue(property, value);
            newValue = beanWrapper.getPropertyValue(property);
        }
        catch (InvalidPropertyException e) {
            newValue = null;
        }
        catch (Exception e) {
            newValue = null;
        }
        return newValue;
    }
}

