/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.query.resolver;

import com.ailikes.common.query.annotation.PageableDefaults;
import com.ailikes.common.query.data.PageRequest;
import com.ailikes.common.query.data.Pageable;
import com.ailikes.common.query.data.Sort;
import com.ailikes.common.query.resolver.BaseMethodArgumentResolver;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageableMethodArgumentResolver
extends BaseMethodArgumentResolver {
    private static final Pageable DEFAULT_PAGE_REQUEST = new PageRequest(0, 10);
    private static final String DEFAULT_PAGE_PREFIX = "page";
    private static final String DEFAULT_SORT_PREFIX = "sort";
    private Pageable fallbackPagable = DEFAULT_PAGE_REQUEST;
    private String pagePrefix = "page";
    private String sortPrefix = "sort";
    private int minPageSize = 1;
    private int maxPageSize = 100;

    public void setMinPageSize(int minPageSize) {
        this.minPageSize = minPageSize;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public void setFallbackPagable(Pageable fallbackPagable) {
        this.fallbackPagable = null == fallbackPagable ? DEFAULT_PAGE_REQUEST : fallbackPagable;
    }

    public void setPagePrefix(String pagePrefix) {
        this.pagePrefix = null == pagePrefix ? DEFAULT_PAGE_PREFIX : pagePrefix;
    }

    public void setSortPrefix(String sortPrefix) {
        this.sortPrefix = null == sortPrefix ? DEFAULT_SORT_PREFIX : sortPrefix;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return Pageable.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Object sort;
        PageableDefaults pageableDefaults = this.getPageableDefaults(parameter);
        Pageable defaultPageRequest = this.getDefaultFromAnnotationOrFallback(pageableDefaults);
        String pageableNamePrefix = this.getPagePrefix(parameter);
        String sortNamePrefix = this.getSortPrefix(parameter);
        Map<String, String[]> pageableMap = this.getPrefixParameterMap(pageableNamePrefix, webRequest, true);
        Map<String, String[]> sortMap = this.getPrefixParameterMap(sortNamePrefix, webRequest, false);
        String gridtype = webRequest.getParameter("gridtype");
        if (!StringUtils.isEmpty((Object)gridtype) && gridtype.equals("jqgrid")) {
            sortMap.clear();
            sort = webRequest.getParameter(DEFAULT_SORT_PREFIX);
            String order = webRequest.getParameter("order");
            if (((String)sort).contains("asc") || ((String)sort).contains("desc")) {
                String[] sortArr;
                for (String sortItem : sortArr = ((String)sort).split(",")) {
                    String[] orderList;
                    String[] sortItemArr = sortItem.trim().split(" ");
                    if (sortItemArr.length == 2) {
                        orderList = new String[]{sortItemArr[1].trim()};
                        sortMap.put("sort." + sortItemArr[0].trim(), orderList);
                        continue;
                    }
                    orderList = new String[]{order};
                    sortMap.put("sort." + sortItemArr[0].trim(), orderList);
                }
            } else {
                String[] orderList = new String[]{webRequest.getParameter("order")};
                sortMap.put("sort." + webRequest.getParameter(DEFAULT_SORT_PREFIX), orderList);
            }
        }
        if (sortMap.isEmpty() && !StringUtils.isEmpty((Object)webRequest.getParameter(DEFAULT_SORT_PREFIX))) {
            String[] orderList = new String[]{webRequest.getParameter("order")};
            sortMap.put("sort." + webRequest.getParameter(DEFAULT_SORT_PREFIX), orderList);
        }
        sort = this.getSort(sortNamePrefix, sortMap, defaultPageRequest, webRequest);
        if (pageableMap.size() == 0) {
            return new PageRequest(defaultPageRequest.getPageNumber(), defaultPageRequest.getPageSize(), (Sort)(sort == null ? defaultPageRequest.getSort() : sort));
        }
        int pn = this.getPageNumber(pageableMap, defaultPageRequest);
        int pageSize = this.getPageSize(pageableMap, defaultPageRequest);
        return new PageRequest(pn, pageSize, (Sort)sort);
    }

    private Sort getSort(String sortNamePrefix, Map<String, String[]> sortMap, Pageable defaultPageRequest, NativeWebRequest webRequest) {
        Sort sort = null;
        try {
            ArrayList orderedSortList = Lists.newArrayList();
            for (String name : sortMap.keySet()) {
                String value = sortMap.get(name)[0];
                if (StringUtils.isEmpty((Object)value)) continue;
                int propertyIndex = name.indexOf(".") + 1;
                int order = 0;
                String orderStr = name.substring(sortNamePrefix.length(), propertyIndex - 1);
                if (!StringUtils.isEmpty((Object)orderStr)) {
                    order = Integer.valueOf(orderStr);
                }
                String property = name.substring(propertyIndex);
                this.assertSortProperty(property);
                Sort.Direction direction = Sort.Direction.fromString(sortMap.get(name)[0]);
                orderedSortList.add(new OrderedSort(property, direction, order));
            }
            Collections.sort(orderedSortList);
            for (OrderedSort orderedSort : orderedSortList) {
                Sort newSort = new Sort(orderedSort.direction, orderedSort.property);
                if (sort == null) {
                    sort = newSort;
                    continue;
                }
                sort = sort.and(newSort);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sort == null) {
            return defaultPageRequest.getSort();
        }
        return sort;
    }

    private void assertSortProperty(String property) {
        if (!property.matches("[a-zA-Z0-9_\u3001.`\"]*")) {
            throw new IllegalStateException("Sort property error, only contains [a-zA-Z0-9_.`\"]");
        }
    }

    private int getPageSize(Map<String, String[]> pageableMap, Pageable defaultPageRequest) {
        int pageSize = 0;
        try {
            String pageSizeStr = pageableMap.get("size")[0];
            pageSize = pageSizeStr != null ? Integer.valueOf(pageSizeStr).intValue() : defaultPageRequest.getPageSize();
        }
        catch (Exception e) {
            pageSize = defaultPageRequest.getPageSize();
        }
        if (pageSize < this.minPageSize) {
            pageSize = this.minPageSize;
        }
        if (pageSize > this.maxPageSize) {
            pageSize = this.maxPageSize;
        }
        return pageSize;
    }

    private int getPageNumber(Map<String, String[]> pageableMap, Pageable defaultPageRequest) {
        int number = 1;
        try {
            String numberStr = pageableMap.get("pn")[0];
            number = numberStr != null ? Integer.valueOf(numberStr).intValue() : defaultPageRequest.getPageNumber();
        }
        catch (Exception e) {
            number = defaultPageRequest.getPageNumber();
        }
        if (number < 1) {
            number = 1;
        }
        return number;
    }

    private String getPagePrefix(MethodParameter parameter) {
        Qualifier qualifier = (Qualifier)parameter.getParameterAnnotation(Qualifier.class);
        if (qualifier != null) {
            return qualifier.value() + "_" + this.pagePrefix;
        }
        return this.pagePrefix;
    }

    private String getSortPrefix(MethodParameter parameter) {
        Qualifier qualifier = (Qualifier)parameter.getParameterAnnotation(Qualifier.class);
        if (qualifier != null) {
            return qualifier.value() + "_" + this.sortPrefix;
        }
        return this.sortPrefix;
    }

    private Pageable getDefaultFromAnnotationOrFallback(PageableDefaults pageableDefaults) {
        Pageable defaultPageable = this.defaultPageable(pageableDefaults);
        if (defaultPageable != null) {
            return defaultPageable;
        }
        return this.fallbackPagable;
    }

    private PageableDefaults getPageableDefaults(MethodParameter parameter) {
        PageableDefaults pageableDefaults = (PageableDefaults)parameter.getParameterAnnotation(PageableDefaults.class);
        if (pageableDefaults == null) {
            pageableDefaults = (PageableDefaults)parameter.getMethodAnnotation(PageableDefaults.class);
        }
        return pageableDefaults;
    }

    private Pageable defaultPageable(PageableDefaults pageableDefaults) {
        if (pageableDefaults == null) {
            return null;
        }
        int pageNumber = pageableDefaults.pageNumber();
        int pageSize = pageableDefaults.value();
        String[] sortStrArray = pageableDefaults.sort();
        Sort sort = null;
        for (String sortStr : sortStrArray) {
            String[] sortStrPair = sortStr.split("=");
            Sort newSort = new Sort(Sort.Direction.fromString(sortStrPair[1]), sortStrPair[0]);
            sort = sort == null ? newSort : sort.and(newSort);
        }
        return new PageRequest(pageNumber, pageSize, sort);
    }

    private void assertPageableUniqueness(MethodParameter parameter) {
        Method method = parameter.getMethod();
        if (this.containsMoreThanOnePageableParameter(method)) {
            Annotation[][] annotations = method.getParameterAnnotations();
            this.assertQualifiersFor(method.getParameterTypes(), annotations);
        }
    }

    private boolean containsMoreThanOnePageableParameter(Method method) {
        boolean pageableFound = false;
        for (Class<?> type : method.getParameterTypes()) {
            if (pageableFound && type.equals(Pageable.class)) {
                return true;
            }
            if (!type.equals(Pageable.class)) continue;
            pageableFound = true;
        }
        return false;
    }

    private void assertQualifiersFor(Class<?>[] parameterTypes, Annotation[][] annotations) {
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < annotations.length; ++i) {
            if (!Pageable.class.equals(parameterTypes[i])) continue;
            Qualifier qualifier = this.findAnnotation(annotations[i]);
            if (null == qualifier) {
                throw new IllegalStateException("Ambiguous Pageable arguments in handler method. If you use multiple parameters of type Pageable you need to qualify them with @Qualifier");
            }
            if (values.contains(qualifier.value())) {
                throw new IllegalStateException("Values of the user Qualifiers must be unique!");
            }
            values.add(qualifier.value());
        }
    }

    private Qualifier findAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Qualifier)) continue;
            return (Qualifier)annotation;
        }
        return null;
    }

    static class OrderedSort
    implements Comparable<OrderedSort> {
        private String property;
        private Sort.Direction direction;
        private int order = 0;

        OrderedSort(String property, Sort.Direction direction, int order) {
            this.property = property;
            this.direction = direction;
            this.order = order;
        }

        @Override
        public int compareTo(OrderedSort o) {
            if (o == null) {
                return -1;
            }
            if (this.order > o.order) {
                return 1;
            }
            if (this.order < o.order) {
                return -1;
            }
            return 0;
        }
    }
}

