/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.query.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.StringUtils;

public class Condition
implements Iterable<Filter>,
Serializable {
    private static final long serialVersionUID = 5737186511678863905L;
    public static final Operator DEFAULT_OPERATOR = Operator.custom;
    private final List<Filter> filters = new ArrayList<Filter>();

    public Condition(Filter ... filters) {
        this.filters.addAll(Arrays.asList(filters));
    }

    public Condition(List<Filter> filters) {
        if (null == filters || filters.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one condition property to condition by!");
        }
        this.filters.addAll(filters);
    }

    public Condition and(Operator operator, String property, Object value) {
        Filter filter = new Filter(operator, property, value);
        this.filters.add(filter);
        return this;
    }

    public Condition and(Condition condition) {
        if (condition == null) {
            return this;
        }
        for (Filter filter : condition) {
            this.filters.add(filter);
        }
        return this;
    }

    public void remove(Filter filter) {
        if (this.filters.contains(filter)) {
            this.filters.remove(filter);
        }
    }

    public void remove(String property) {
        for (Filter filter : this) {
            if (!filter.getProperty().equals(property)) continue;
            this.remove(filter);
        }
    }

    public Filter getFilterFor(String property) {
        for (Filter filter : this) {
            if (!filter.getProperty().equals(property)) continue;
            return filter;
        }
        return null;
    }

    @Override
    public Iterator<Filter> iterator() {
        return this.filters.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition that = (Condition)obj;
        return this.filters.equals(that.filters);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.filters.hashCode();
        return result;
    }

    public String toString() {
        return StringUtils.collectionToCommaDelimitedString(this.filters);
    }

    public static class Filter
    implements Serializable {
        private static final long serialVersionUID = 1522511010900108987L;
        private static final boolean DEFAULT_IGNORE_CASE = false;
        private final Operator operator;
        private final String property;
        private Object value;

        public Filter(String property, Object value) {
            this(DEFAULT_OPERATOR, property, value);
        }

        public Filter(Operator operator, String property, Object value) {
            this(operator, property, value, false);
        }

        private Filter(Operator operator, String property, Object value, boolean ignoreCase) {
            if (!StringUtils.hasText((String)property)) {
                throw new IllegalArgumentException("Property must not null or empty!");
            }
            this.operator = operator == null ? DEFAULT_OPERATOR : operator;
            this.property = property;
            this.value = value;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public String getProperty() {
            return this.property;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Filter with(Operator filter, Object value) {
            return new Filter(filter, this.property, value);
        }

        public Filter ignoreCase() {
            return new Filter(this.operator, this.property, true);
        }

        public boolean isUnaryFilter() {
            String operatorStr = this.getOperator().getSymbol();
            return !StringUtils.isEmpty((Object)operatorStr) && operatorStr.startsWith("is");
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.operator.hashCode();
            result = 31 * result + this.property.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Filter)) {
                return false;
            }
            Filter that = (Filter)obj;
            return this.operator.equals((Object)that.operator) && this.property.equals(that.property);
        }

        public String toString() {
            return String.format("%s: %s", new Object[]{this.property, this.operator});
        }
    }

    public static enum Operator {
        eq("\u7b49\u4e8e", "="),
        ne("\u4e0d\u7b49\u4e8e", "!="),
        gt("\u5927\u4e8e", ">"),
        ge("\u5927\u4e8e\u7b49\u4e8e", ">="),
        lt("\u5c0f\u4e8e", "<"),
        le("\u5c0f\u4e8e\u7b49\u4e8e", "<="),
        isNull("\u7a7a", "is null"),
        isNotNull("\u975e\u7a7a", "is not null"),
        in("\u5305\u542b", "in"),
        notIn("\u4e0d\u5305\u542b", "not in"),
        between("\u5bf9\u5e94SQL\u7684between\u5b50\u53e5", "between"),
        prefixLike("\u524d\u7f00\u6a21\u7cca\u5339\u914d", "like"),
        prefixNotLike("\u524d\u7f00\u6a21\u7cca\u4e0d\u5339\u914d", "not like"),
        suffixLike("\u540e\u7f00\u6a21\u7cca\u5339\u914d", "like"),
        suffixNotLike("\u540e\u7f00\u6a21\u7cca\u4e0d\u5339\u914d", "not like"),
        like("\u6a21\u7cca\u5339\u914d", "like"),
        notLike("\u4e0d\u5339\u914d", "not like"),
        custom("\u81ea\u5b9a\u4e49\u9ed8\u8ba4\u7684", null);

        private final String info;
        private final String symbol;

        private Operator(String info, String symbol) {
            this.info = info;
            this.symbol = symbol;
        }

        public String getInfo() {
            return this.info;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public static Operator fromString(String value) {
            try {
                return Operator.valueOf(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid value '%s' for filters given! Has to be either 'desc' or 'asc' (case insensitive).", value), e);
            }
        }

        public static Operator fromStringOrNull(String value) {
            try {
                return Operator.fromString(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String toStringAllOperator() {
            return Arrays.toString((Object[])Operator.values());
        }

        public static boolean isAllowBlankValue(Operator operator) {
            return operator == isNotNull || operator == isNull;
        }
    }
}

