/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.query.data;

import com.ailikes.common.query.data.PropertyPreFilterable;
import com.ailikes.common.utils.ComplexPropertyPreFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class QueryPropertyPreFilter
implements PropertyPreFilterable {
    private String queryPropertyStr;
    private Set<String> queryPropertys;
    private ComplexPropertyPreFilter complexPropertyPreFilter;

    public QueryPropertyPreFilter() {
        this.init("");
    }

    public QueryPropertyPreFilter(String queryPropertyStr) {
        this.init(queryPropertyStr);
    }

    public void init(String queryPropertyStr) {
        this.queryPropertyStr = queryPropertyStr;
        this.queryPropertys = new HashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)this.queryPropertyStr)) {
            String[] queryPropertys;
            this.queryPropertyStr = this.queryPropertyStr.substring(0, this.queryPropertyStr.length() - 1);
            for (String queryProperty : queryPropertys = this.queryPropertyStr.split(",")) {
                this.queryPropertys.add(queryProperty);
            }
        }
        if (this.complexPropertyPreFilter == null) {
            this.complexPropertyPreFilter = new ComplexPropertyPreFilter();
        }
    }

    @Override
    public SerializeFilter constructFilter(Class<?> clazz) {
        for (String queryProperty : this.queryPropertys) {
            if (!queryProperty.contains(".")) {
                this.complexPropertyPreFilter.addIncludeFilter(clazz, new String[]{queryProperty});
                continue;
            }
            this.constructSubClass(clazz, queryProperty);
        }
        return this.complexPropertyPreFilter;
    }

    public void constructSubClass(Class<?> clazz, String queryProperty) {
        String[] querySubPropertys;
        for (String querySubProperty : querySubPropertys = queryProperty.split("\\.")) {
            if (clazz == null) continue;
            this.complexPropertyPreFilter.addIncludeFilter(clazz, new String[]{querySubProperty});
            Class<?> subClazz = this.getSubClass(clazz, querySubProperty);
            clazz = subClazz;
        }
    }

    public Class<?> getSubClass(Class<?> clazz, String fieldname) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String name = field.getName();
            Class<?> type = field.getType();
            if (!fieldname.equals(name)) continue;
            return type;
        }
        return null;
    }

    @Override
    public void addQueryProperty(String ... properties) {
        for (String item : properties) {
            if (item == null) continue;
            this.queryPropertys.add(item);
        }
    }

    @Override
    public void addIncludeFilter(Class<?> clazz, String ... properties) {
        this.complexPropertyPreFilter.addIncludeFilter(clazz, properties);
    }

    @Override
    public void addExcludeFilter(Class<?> clazz, String ... properties) {
        this.complexPropertyPreFilter.addExcludeFilter(clazz, properties);
    }
}

