/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.query.resolver;

import com.ailikes.common.query.annotation.RequestJsonParam;
import com.ailikes.common.utils.mapper.JsonMapper;
import com.ailikes.common.utils.mapper.MapWapper;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.AbstractNamedValueMethodArgumentResolver;

public class RequestJsonParamMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver
implements WebArgumentResolver {
    private JsonMapper mapper = new JsonMapper();

    public RequestJsonParamMethodArgumentResolver() {
        super(null);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestJsonParam.class);
    }

    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestJsonParam annotation = (RequestJsonParam)parameter.getParameterAnnotation(RequestJsonParam.class);
        return new RequestJsonParamNamedValueInfo(annotation);
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest webRequest) throws Exception {
        String[] paramValues = webRequest.getParameterValues(name);
        Class paramType = parameter.getParameterType();
        if (paramValues == null) {
            return null;
        }
        try {
            if (paramValues.length == 1) {
                String text = StringEscapeUtils.unescapeHtml4((String)paramValues[0]);
                Type type = parameter.getGenericParameterType();
                if (MapWapper.class.isAssignableFrom(paramType)) {
                    MapWapper jsonMap = (MapWapper)paramType.newInstance();
                    MapType mapType = (MapType)this.getJavaType(HashMap.class);
                    if (type instanceof ParameterizedType) {
                        mapType = mapType.withKeyType((JavaType)((ParameterizedType)type).getActualTypeArguments()[0]);
                        mapType = (MapType)mapType.withContentType((JavaType)((ParameterizedType)type).getActualTypeArguments()[1]);
                    }
                    jsonMap.setInnerMap((Map)this.mapper.readValue(text, (JavaType)mapType));
                    return jsonMap;
                }
                JavaType javaType = this.getJavaType(paramType);
                if (Collection.class.isAssignableFrom(paramType)) {
                    javaType = javaType.withContentType((JavaType)((ParameterizedType)type).getActualTypeArguments()[0]);
                }
                return this.mapper.readValue(text, javaType);
            }
        }
        catch (Exception e) {
            throw new JsonMappingException("Could not read request json parameter", (Throwable)e);
        }
        throw new UnsupportedOperationException("too many request json parameter '" + name + "' for method parameter type [" + paramType + "], only support one json parameter");
    }

    protected JavaType getJavaType(Class<?> clazz) {
        return TypeFactory.defaultInstance().constructType(clazz);
    }

    protected void handleMissingValue(String paramName, MethodParameter parameter) throws ServletException {
        String paramType = parameter.getParameterType().getName();
        throw new ServletRequestBindingException("Missing request json parameter '" + paramName + "' for method parameter type [" + paramType + "]");
    }

    public Object resolveArgument(MethodParameter parameter, NativeWebRequest request) throws Exception {
        if (!this.supportsParameter(parameter)) {
            return WebArgumentResolver.UNRESOLVED;
        }
        return this.resolveArgument(parameter, null, request, null);
    }

    private class RequestJsonParamNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        private RequestJsonParamNamedValueInfo() {
            super("", false, null);
        }

        private RequestJsonParamNamedValueInfo(RequestJsonParam annotation) {
            super(annotation.value(), annotation.required(), null);
        }
    }
}

