/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.query.resolver;

import com.ailikes.common.query.data.PropertyPreFilterable;
import com.ailikes.common.query.data.QueryPropertyPreFilter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PropertyPreFilterMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String DEFAULT_FILTER = "queryFields";
    private String filterName = "queryFields";

    public boolean supportsParameter(MethodParameter parameter) {
        return PropertyPreFilterable.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String propertyPreFilterName = this.getFilterName(parameter);
        String queryFields = webRequest.getParameter(propertyPreFilterName);
        return new QueryPropertyPreFilter(queryFields);
    }

    private String getFilterName(MethodParameter parameter) {
        Qualifier qualifier = (Qualifier)parameter.getParameterAnnotation(Qualifier.class);
        if (qualifier != null) {
            return qualifier.value() + "_" + this.filterName;
        }
        return this.filterName;
    }
}

