/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.query.resolver;

import com.ailikes.common.query.annotation.FormModel;
import com.ailikes.common.utils.mapper.MapWapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.WebUtils;

public class FormModelMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(FormModel.class);
    }

    public final Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws Exception {
        String name = ((FormModel)parameter.getParameterAnnotation(FormModel.class)).value();
        Object target = mavContainer.containsAttribute(name) ? mavContainer.getModel().get((Object)name) : this.createAttribute(name, parameter, binderFactory, request);
        WebDataBinder binder = binderFactory.createBinder(request, target, name);
        if ((target = binder.getTarget()) != null) {
            this.bindRequestParameters(mavContainer, binderFactory, binder, request, parameter);
            this.validateIfApplicable(binder, parameter);
            if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
                throw new BindException(binder.getBindingResult());
            }
        }
        target = binder.convertIfNecessary(binder.getTarget(), parameter.getParameterType());
        mavContainer.addAttribute(name, target);
        return target;
    }

    protected Object createAttribute(String attributeName, MethodParameter parameter, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        Object attribute;
        String value = this.getRequestValueForAttribute(attributeName, request);
        if (value != null && (attribute = this.createAttributeFromRequestValue(value, attributeName, parameter, binderFactory, request)) != null) {
            return attribute;
        }
        Class parameterType = parameter.getParameterType();
        if (parameterType.isArray() || List.class.isAssignableFrom(parameterType)) {
            return ArrayList.class.newInstance();
        }
        if (Set.class.isAssignableFrom(parameterType)) {
            return HashSet.class.newInstance();
        }
        if (MapWapper.class.isAssignableFrom(parameterType)) {
            return MapWapper.class.newInstance();
        }
        return BeanUtils.instantiateClass((Class)parameter.getParameterType());
    }

    protected String getRequestValueForAttribute(String attributeName, NativeWebRequest request) {
        Map<String, String> variables = this.getUriTemplateVariables(request);
        if (StringUtils.hasText((String)variables.get(attributeName))) {
            return variables.get(attributeName);
        }
        if (StringUtils.hasText((String)request.getParameter(attributeName))) {
            return request.getParameter(attributeName);
        }
        return null;
    }

    protected final Map<String, String> getUriTemplateVariables(NativeWebRequest request) {
        Map<String, String> variables = (Map<String, String>)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        return variables != null ? variables : Collections.emptyMap();
    }

    protected Object createAttributeFromRequestValue(String sourceValue, String attributeName, MethodParameter parameter, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        TypeDescriptor target;
        TypeDescriptor source;
        WebDataBinder binder = binderFactory.createBinder(request, null, attributeName);
        ConversionService conversionService = binder.getConversionService();
        if (conversionService != null && conversionService.canConvert(source = TypeDescriptor.valueOf(String.class), target = new TypeDescriptor(parameter))) {
            return binder.convertIfNecessary((Object)sourceValue, parameter.getParameterType(), parameter);
        }
        return null;
    }

    protected void bindRequestParameters(ModelAndViewContainer mavContainer, WebDataBinderFactory binderFactory, WebDataBinder binder, NativeWebRequest request, MethodParameter parameter) throws Exception {
        Class<?> targetType = binder.getTarget().getClass();
        ServletRequest servletRequest = (ServletRequest)request;
        WebDataBinder simpleBinder = binderFactory.createBinder(request, null, null);
        if (Collection.class.isAssignableFrom(targetType)) {
            Type type = parameter.getGenericParameterType();
            Class<?> componentType = Object.class;
            Collection target = (Collection)binder.getTarget();
            if (type instanceof ParameterizedType) {
                componentType = (Class<?>)((ParameterizedType)type).getActualTypeArguments()[0];
            }
            if (parameter.getParameterType().isArray()) {
                componentType = parameter.getParameterType().getComponentType();
            }
            for (Object key : servletRequest.getParameterMap().keySet()) {
                String prefixName = this.getPrefixName((String)key);
                if (this.isSimpleComponent(prefixName)) {
                    Map paramValues = WebUtils.getParametersStartingWith((ServletRequest)servletRequest, (String)prefixName);
                    for (Object value : paramValues.values()) {
                        target.add(simpleBinder.convertIfNecessary(value, componentType));
                    }
                    continue;
                }
                Object component = BeanUtils.instantiate(componentType);
                WebDataBinder componentBinder = binderFactory.createBinder(request, component, null);
                if ((component = componentBinder.getTarget()) == null) continue;
                ServletRequestParameterPropertyValues pvs = new ServletRequestParameterPropertyValues(servletRequest, prefixName, "");
                componentBinder.bind((PropertyValues)pvs);
                this.validateIfApplicable(componentBinder, parameter);
                if (componentBinder.getBindingResult().hasErrors() && this.isBindExceptionRequired(componentBinder, parameter)) {
                    throw new BindException(componentBinder.getBindingResult());
                }
                target.add(component);
            }
        } else if (MapWapper.class.isAssignableFrom(targetType)) {
            Type type = parameter.getGenericParameterType();
            Class keyType = Object.class;
            Class valueType = Object.class;
            if (type instanceof ParameterizedType) {
                keyType = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                valueType = (Class)((ParameterizedType)type).getActualTypeArguments()[1];
            }
            HashMap<Object, Object> target = new HashMap<Object, Object>();
            ((MapWapper)binder.getTarget()).setInnerMap(target);
            for (Object key : servletRequest.getParameterMap().keySet()) {
                String prefixName = this.getPrefixName((String)key);
                Object keyValue = simpleBinder.convertIfNecessary(this.getMapKey(prefixName), keyType);
                if (this.isSimpleComponent(prefixName)) {
                    Map paramValues = WebUtils.getParametersStartingWith((ServletRequest)servletRequest, (String)prefixName);
                    for (Object value : paramValues.values()) {
                        target.put(keyValue, simpleBinder.convertIfNecessary(value, valueType));
                    }
                    continue;
                }
                Object component = BeanUtils.instantiate((Class)valueType);
                WebDataBinder componentBinder = binderFactory.createBinder(request, component, null);
                if ((component = componentBinder.getTarget()) == null) continue;
                ServletRequestParameterPropertyValues pvs = new ServletRequestParameterPropertyValues(servletRequest, prefixName, "");
                componentBinder.bind((PropertyValues)pvs);
                this.validateComponent(componentBinder, parameter);
                target.put(keyValue, component);
            }
        } else {
            ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
            servletBinder.bind(servletRequest);
        }
    }

    private Object getMapKey(String prefixName) {
        String key = prefixName;
        if (key.startsWith("['")) {
            key = key.replaceAll("\\['", "").replaceAll("'\\]", "");
        }
        if (key.startsWith("[\"")) {
            key = key.replaceAll("\\[\"", "").replaceAll("\"\\]", "");
        }
        if (key.endsWith(".")) {
            key = key.substring(0, key.length() - 1);
        }
        return key;
    }

    private boolean isSimpleComponent(String prefixName) {
        return !prefixName.endsWith(".");
    }

    private String getPrefixName(String name) {
        int begin = 0;
        int end = name.indexOf("]") + 1;
        if (name.indexOf("].") >= 0) {
            ++end;
        }
        return name.substring(begin, end);
    }

    private String getNewParameterName(String parameterName, String modelPrefixName) {
        int modelPrefixNameLength = modelPrefixName.length();
        if (parameterName.charAt(modelPrefixNameLength) == '.') {
            return parameterName.substring(modelPrefixNameLength + 1);
        }
        if (parameterName.charAt(modelPrefixNameLength) == '[') {
            return parameterName.substring(modelPrefixNameLength);
        }
        throw new IllegalArgumentException("illegal request parameter, can not binding to @FormBean(" + modelPrefixName + ")");
    }

    private boolean isFormModelAttribute(String parameterName, String modelPrefixName) {
        int modelPrefixNameLength = modelPrefixName.length();
        if (parameterName.length() == modelPrefixNameLength) {
            return false;
        }
        if (!parameterName.startsWith(modelPrefixName)) {
            return false;
        }
        char ch = parameterName.charAt(modelPrefixNameLength);
        return ch == '.' || ch == '[';
    }

    protected void validateComponent(WebDataBinder binder, MethodParameter parameter) throws BindException {
        Annotation[] annotations;
        boolean validateParameter = this.validateParameter(parameter);
        for (Annotation annot : annotations = binder.getTarget().getClass().getAnnotations()) {
            Object[] objectArray;
            if (!annot.annotationType().getSimpleName().startsWith("Valid") || !validateParameter) continue;
            Object hints = AnnotationUtils.getValue((Annotation)annot);
            if (hints instanceof Object[]) {
                objectArray = (Object[])hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            binder.validate(objectArray);
        }
        if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
            throw new BindException(binder.getBindingResult());
        }
    }

    private boolean validateParameter(MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation annot : annotations = parameter.getParameterAnnotations()) {
            if (!annot.annotationType().getSimpleName().startsWith("Valid")) continue;
            return true;
        }
        return false;
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation annot : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            if (!annot.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object hints = AnnotationUtils.getValue((Annotation)annot);
            if (hints instanceof Object[]) {
                objectArray = (Object[])hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            binder.validate(objectArray);
        }
    }

    protected boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getMethod().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }
}

