/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.quartz.config;

import com.ailikes.common.quartz.QuartzManager;
import com.ailikes.common.quartz.callback.QuartzInitCallback;
import com.ailikes.common.utils.SpringContextHolder;
import com.ailikes.common.utils.StringUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.quartz.Scheduler;
import org.quartz.ee.servlet.QuartzInitializerListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class QuartzConfig
implements ApplicationRunner {
    @Autowired
    private Environment env;

    public void run(ApplicationArguments args) throws Exception {
        String openCluster = this.env.getProperty("quartz.open-cluster");
        if (StringUtils.isEmpty((String)openCluster) || !Boolean.valueOf(openCluster).booleanValue()) {
            Map quartzInitCallbackBeans = SpringContextHolder.getApplicationContext().getBeansOfType(QuartzInitCallback.class);
            for (QuartzInitCallback quartzInitCallback : quartzInitCallbackBeans.values()) {
                try {
                    quartzInitCallback.initSchedule();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Bean
    public QuartzManager quartzManager() {
        QuartzManager quartzManager = new QuartzManager();
        return quartzManager;
    }

    @Bean
    @ConditionalOnProperty(name={"quartz.open-cluster"}, havingValue="true")
    @DependsOn(value={"springContextHolder", "dataSource"})
    public SchedulerFactoryBean schedulerFactoryBean(DataSource dataSource) throws IOException {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        String dataSourceBean = this.env.getProperty("quartz.data-source");
        if (StringUtils.isEmpty((String)dataSourceBean) || dataSourceBean.equals("default")) {
            schedulerFactoryBean.setDataSource(dataSource);
        }
        schedulerFactoryBean.setQuartzProperties(this.quartzProperties());
        schedulerFactoryBean.setSchedulerName("JeeWebScheduler");
        schedulerFactoryBean.setStartupDelay(1);
        schedulerFactoryBean.setApplicationContextSchedulerContextKey("applicationContextKey");
        schedulerFactoryBean.setOverwriteExistingJobs(true);
        schedulerFactoryBean.setAutoStartup(true);
        return schedulerFactoryBean;
    }

    @Bean
    @ConditionalOnProperty(name={"quartz.open-cluster"}, havingValue="true")
    public Properties quartzProperties() throws IOException {
        String configLocation = this.env.getProperty("quartz.config-location");
        if (StringUtils.isEmpty((String)configLocation)) {
            configLocation = "/quartz/quartz.properties";
        }
        PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
        propertiesFactoryBean.setLocation((Resource)new ClassPathResource(configLocation));
        propertiesFactoryBean.afterPropertiesSet();
        return propertiesFactoryBean.getObject();
    }

    @Bean
    @ConditionalOnProperty(name={"quartz.open-cluster"}, havingValue="true")
    public QuartzInitializerListener executorListener() {
        return new QuartzInitializerListener();
    }

    public Scheduler scheduler(SchedulerFactoryBean schedulerFactoryBean) throws IOException {
        return schedulerFactoryBean.getScheduler();
    }
}

