/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.quartz;

import com.ailikes.common.quartz.data.ScheduleJob;
import com.ailikes.common.quartz.exception.QuartzException;
import com.ailikes.common.quartz.factory.QuartzJobFactory;
import com.ailikes.common.quartz.factory.QuartzJobFactoryDisallowConcurrentExecution;
import com.ailikes.common.utils.SpringContextHolder;
import com.ailikes.common.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class QuartzManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public static TriggerKey getTriggerKey(ScheduleJob job) {
        return TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
    }

    public static JobKey getJobKey(ScheduleJob job) {
        return JobKey.jobKey((String)job.getJobName(), (String)job.getJobGroup());
    }

    public static CronScheduleBuilder handleCronScheduleMisfirePolicy(ScheduleJob scheduleJob, CronScheduleBuilder cb) throws QuartzException {
        String misfirePolicy = scheduleJob.getMisfirePolicy();
        if (StringUtils.isEmpty((String)misfirePolicy)) {
            misfirePolicy = "0";
        }
        switch (misfirePolicy) {
            case "0": {
                return cb;
            }
            case "1": {
                return cb.withMisfireHandlingInstructionIgnoreMisfires();
            }
            case "2": {
                return cb.withMisfireHandlingInstructionFireAndProceed();
            }
            case "3": {
                return cb.withMisfireHandlingInstructionDoNothing();
            }
        }
        throw new QuartzException("The task misfire policy '" + scheduleJob.getMisfirePolicy() + "' cannot be used in cron schedule tasks");
    }

    public void addJob(ScheduleJob job) throws SchedulerException {
        if (job == null || !"1".equals(job.getJobStatus())) {
            return;
        }
        Scheduler scheduler = ((SchedulerFactoryBean)SpringContextHolder.getBean(SchedulerFactoryBean.class)).getScheduler();
        this.logger.debug(scheduler + ".......................................................................................add");
        TriggerKey triggerKey = QuartzManager.getTriggerKey(job);
        CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
        if (null == trigger) {
            Class clazz = "1".equals(job.getIsConcurrent()) ? QuartzJobFactory.class : QuartzJobFactoryDisallowConcurrentExecution.class;
            JobDetail jobDetail = JobBuilder.newJob(clazz).storeDurably().requestRecovery().withIdentity(QuartzManager.getJobKey(job)).withDescription(job.getDescription()).build();
            jobDetail.getJobDataMap().put("TASK_JOB_BAEN_KEY", (Object)job);
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCronExpression());
            scheduleBuilder = QuartzManager.handleCronScheduleMisfirePolicy(job, scheduleBuilder);
            trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(QuartzManager.getTriggerKey(job)).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        } else {
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCronExpression());
            scheduleBuilder = QuartzManager.handleCronScheduleMisfirePolicy(job, scheduleBuilder);
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
        }
        if (job.equals("0")) {
            this.pauseJob(job);
        }
    }

    public List<ScheduleJob> getAllJob() throws SchedulerException {
        Scheduler scheduler = ((SchedulerFactoryBean)SpringContextHolder.getBean(SchedulerFactoryBean.class)).getScheduler();
        GroupMatcher matcher = GroupMatcher.anyJobGroup();
        Set jobKeys = scheduler.getJobKeys(matcher);
        ArrayList<ScheduleJob> jobList = new ArrayList<ScheduleJob>();
        for (JobKey jobKey : jobKeys) {
            List triggers = scheduler.getTriggersOfJob(jobKey);
            for (Trigger trigger : triggers) {
                JobDetail jobDetail = scheduler.getJobDetail(jobKey);
                ScheduleJob job = (ScheduleJob)jobDetail.getJobDataMap().get((Object)"TASK_JOB_BAEN_KEY");
                Trigger.TriggerState triggerState = scheduler.getTriggerState(trigger.getKey());
                job.setJobStatus(triggerState.name());
                if (trigger instanceof CronTrigger) {
                    CronTrigger cronTrigger = (CronTrigger)trigger;
                    String cronExpression = cronTrigger.getCronExpression();
                    job.setCronExpression(cronExpression);
                }
                jobList.add(job);
            }
        }
        return jobList;
    }

    public List<ScheduleJob> getRunningJob() throws SchedulerException {
        Scheduler scheduler = ((SchedulerFactoryBean)SpringContextHolder.getBean(SchedulerFactoryBean.class)).getScheduler();
        List executingJobs = scheduler.getCurrentlyExecutingJobs();
        ArrayList<ScheduleJob> jobList = new ArrayList<ScheduleJob>(executingJobs.size());
        for (JobExecutionContext executingJob : executingJobs) {
            JobDetail jobDetail = executingJob.getJobDetail();
            JobKey jobKey = jobDetail.getKey();
            Trigger trigger = executingJob.getTrigger();
            ScheduleJob job = (ScheduleJob)jobDetail.getJobDataMap().get((Object)"TASK_JOB_BAEN_KEY");
            Trigger.TriggerState triggerState = scheduler.getTriggerState(trigger.getKey());
            job.setJobStatus(triggerState.name());
            if (trigger instanceof CronTrigger) {
                CronTrigger cronTrigger = (CronTrigger)trigger;
                String cronExpression = cronTrigger.getCronExpression();
                job.setCronExpression(cronExpression);
            }
            jobList.add(job);
        }
        return jobList;
    }

    public void pauseJob(ScheduleJob scheduleJob) throws SchedulerException {
        Scheduler scheduler = ((SchedulerFactoryBean)SpringContextHolder.getBean(SchedulerFactoryBean.class)).getScheduler();
        JobKey jobKey = QuartzManager.getJobKey(scheduleJob);
        scheduler.pauseJob(jobKey);
    }

    public void resumeJob(ScheduleJob scheduleJob) throws SchedulerException {
        Scheduler scheduler = ((SchedulerFactoryBean)SpringContextHolder.getBean(SchedulerFactoryBean.class)).getScheduler();
        JobKey jobKey = QuartzManager.getJobKey(scheduleJob);
        scheduler.resumeJob(jobKey);
    }

    public void deleteJob(ScheduleJob scheduleJob) throws SchedulerException {
        Scheduler scheduler = ((SchedulerFactoryBean)SpringContextHolder.getBean(SchedulerFactoryBean.class)).getScheduler();
        JobKey jobKey = QuartzManager.getJobKey(scheduleJob);
        scheduler.deleteJob(jobKey);
    }

    public void runAJobNow(ScheduleJob scheduleJob) throws SchedulerException {
        Scheduler scheduler = ((SchedulerFactoryBean)SpringContextHolder.getBean(SchedulerFactoryBean.class)).getScheduler();
        JobKey jobKey = QuartzManager.getJobKey(scheduleJob);
        scheduler.triggerJob(jobKey);
    }

    public void updateJobCron(ScheduleJob scheduleJob) throws SchedulerException {
        Scheduler scheduler = ((SchedulerFactoryBean)SpringContextHolder.getBean(SchedulerFactoryBean.class)).getScheduler();
        TriggerKey triggerKey = QuartzManager.getTriggerKey(scheduleJob);
        CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCronExpression());
        scheduleBuilder = QuartzManager.handleCronScheduleMisfirePolicy(scheduleJob, scheduleBuilder);
        trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        trigger.getJobDataMap().put("TASK_JOB_BAEN_KEY", (Object)scheduleJob);
        scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
        if (scheduleJob.getJobStatus().equals("0")) {
            this.pauseJob(scheduleJob);
        }
    }

    public void empty() throws SchedulerException {
        Scheduler scheduler = ((SchedulerFactoryBean)SpringContextHolder.getBean(SchedulerFactoryBean.class)).getScheduler();
        GroupMatcher matcher = GroupMatcher.anyJobGroup();
        Set jobKeys = scheduler.getJobKeys(matcher);
        scheduler.deleteJobs((List)Lists.newArrayList((Iterable)jobKeys));
    }
}

