/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.oss.client;

import com.ailikes.common.oss.client.AbstractOSSClient;
import com.ailikes.common.oss.config.LocalConfig;
import com.ailikes.common.oss.config.OssConfig;
import com.ailikes.common.oss.exception.OSSException;
import com.ailikes.common.utils.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class LocalClient
extends AbstractOSSClient {
    public static final String DEFAULT_CONFIG_FILE = "local.properties";
    private String domain;
    private String uploadFilePath;

    @Override
    public void init() {
        this.init(DEFAULT_CONFIG_FILE);
    }

    @Override
    public void init(String propertiesName) {
        PropertiesUtil p = new PropertiesUtil(new String[]{propertiesName});
        this.domain = p.getString("local.domain");
        this.uploadFilePath = p.getString("local.upload-file-path");
    }

    @Override
    public void init(OssConfig config) {
        LocalConfig localConfig = config.getLocal();
        this.domain = localConfig.getDomain();
        this.uploadFilePath = localConfig.getUploadFilePath();
    }

    private File getAbsoluteFile(String path) throws IOException {
        String basePath = this.uploadFilePath;
        File desc = new File(basePath + File.separator + path);
        if (!desc.getParentFile().exists()) {
            desc.getParentFile().mkdirs();
        }
        if (!desc.exists()) {
            desc.createNewFile();
        }
        return desc;
    }

    @Override
    public String upload(InputStream inputStream, String path) {
        try {
            File outFile = this.getAbsoluteFile(path);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)outFile);
        }
        catch (Exception e) {
            throw new OSSException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", e);
        }
        return this.domain + "/" + path;
    }

    @Override
    public void delete(String filename) {
        String basePath = this.uploadFilePath;
        File desc = new File(basePath + File.pathSeparator + filename);
        if (desc.exists()) {
            desc.delete();
        }
    }
}

