/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.oss;

import com.ailikes.common.oss.client.IOSSClient;
import com.ailikes.common.oss.client.OSSClientFactory;
import com.ailikes.common.oss.config.OssConfig;
import com.ailikes.common.oss.exception.FileNameLengthLimitExceededException;
import com.ailikes.common.oss.exception.InvalidExtensionException;
import com.ailikes.common.utils.PropertiesUtil;
import com.ailikes.common.utils.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.web.multipart.MultipartFile;

public class OSSUploadHelper {
    public static final String DEFAULT_CONFIG_FILE = "upload.properties";
    public static final int DEFAULT_FILE_NAME_LENGTH = 200;
    public static final String[] IMAGE_EXTENSION = new String[]{"bmp", "gif", "jpg", "jpeg", "png"};
    public static final String[] FLASH_EXTENSION = new String[]{"swf", "flv"};
    public static final String[] MEDIA_EXTENSION = new String[]{"swf", "flv", "mp3", "wav", "wma", "wmv", "mid", "avi", "mpg", "asf", "rm", "rmvb"};
    private static final String DEFAULT_BASE_DIR = "upload";
    private String ossBaseDir = "upload";
    public static final long DEFAULT_MAX_SIZE = 0x3200000L;
    private long maxSize = 0x3200000L;
    public static final String[] DEFAULT_ALLOWED_EXTENSION = new String[]{"bmp", "gif", "jpg", "jpeg", "png", "doc", "docx", "xls", "xlsx", "ppt", "pptx", "html", "htm", "txt", "rar", "zip", "gz", "bz2", "pdf"};
    public String[] allowedExtension = DEFAULT_ALLOWED_EXTENSION;
    private String clientType = "local";
    private IOSSClient ossClient;

    public void init() {
        this.init(DEFAULT_CONFIG_FILE);
    }

    public void init(String configname) {
        PropertiesUtil propertiesUtil = new PropertiesUtil(new String[]{configname});
        this.maxSize = propertiesUtil.getLong("upload.max.size");
        this.ossBaseDir = propertiesUtil.getString("upload.base.dir");
        String extension = propertiesUtil.getString("upload.allowed.extension");
        this.allowedExtension = extension.split(",");
        this.clientType = propertiesUtil.getString("upload.client.type");
        this.ossClient = OSSClientFactory.build(this.clientType);
        this.ossClient.init();
    }

    public void init(OssConfig ossConfig) {
        this.maxSize = ossConfig.getMaxSize();
        this.ossBaseDir = ossConfig.getBaseDir();
        String extension = ossConfig.getAllowedExtension();
        this.allowedExtension = extension.split(",");
        this.clientType = ossConfig.getClientType();
        this.ossClient = OSSClientFactory.build(this.clientType);
        this.ossClient.init(ossConfig);
    }

    public String upload(HttpServletRequest request, MultipartFile file, String baseDir) throws FileUploadBase.FileSizeLimitExceededException, InvalidExtensionException, FileNameLengthLimitExceededException, IOException {
        return this.upload(request, file, baseDir, this.allowedExtension);
    }

    public String upload(HttpServletRequest request, MultipartFile file, String baseDir, String[] allowedExtension) throws FileUploadBase.FileSizeLimitExceededException, InvalidExtensionException, FileNameLengthLimitExceededException, IOException {
        return this.upload(request, file, baseDir, allowedExtension, this.maxSize, true);
    }

    public String upload(HttpServletRequest request, MultipartFile file, String baseDir, String[] allowedExtension, long maxSize, boolean needDatePathAndRandomName) throws InvalidExtensionException, FileUploadBase.FileSizeLimitExceededException, IOException, FileNameLengthLimitExceededException {
        int fileNamelength = file.getOriginalFilename().length();
        if (fileNamelength > 200) {
            throw new FileNameLengthLimitExceededException(file.getOriginalFilename(), fileNamelength, 200);
        }
        this.assertAllowed(file, allowedExtension, maxSize);
        String filename = this.extractFilename(file, baseDir, needDatePathAndRandomName);
        filename = StringUtils.trimDiagonal((String)filename);
        return this.ossClient.upload(file.getInputStream(), filename);
    }

    public String remote(HttpServletRequest request, String remoteUrl, String baseDir) throws FileUploadBase.FileSizeLimitExceededException, InvalidExtensionException, FileNameLengthLimitExceededException, IOException {
        return this.remote(request, remoteUrl, baseDir, this.allowedExtension);
    }

    public String remote(HttpServletRequest request, String remoteUrl, String baseDir, String[] allowedExtension) throws FileUploadBase.FileSizeLimitExceededException, InvalidExtensionException, FileNameLengthLimitExceededException, IOException {
        return this.remote(request, remoteUrl, baseDir, allowedExtension, this.maxSize, true);
    }

    public String remote(HttpServletRequest request, String remoteUrl, String baseDir, String[] allowedExtension, long maxSize, boolean needDatePathAndRandomName) throws InvalidExtensionException, FileUploadBase.FileSizeLimitExceededException, IOException, FileNameLengthLimitExceededException {
        URL url = new URL(remoteUrl);
        this.assertAllowed(remoteUrl, allowedExtension, maxSize);
        String filename = this.extractFilename(remoteUrl, baseDir, needDatePathAndRandomName);
        filename = StringUtils.trimDiagonal((String)filename);
        return this.ossClient.upload(url.openStream(), filename);
    }

    public String extractFilename(String remoteUrl, String baseDir, boolean needDatePathAndRandomName) throws UnsupportedEncodingException {
        String filename;
        int slashIndex;
        if (!StringUtils.isEmpty((String)this.ossBaseDir)) {
            baseDir = !StringUtils.isEmpty((String)baseDir) ? this.ossBaseDir + "/" + baseDir : this.ossBaseDir;
        }
        if ((slashIndex = (filename = remoteUrl).indexOf("/")) >= 0) {
            filename = filename.substring(slashIndex + 1);
        }
        if (needDatePathAndRandomName) {
            filename = this.datePath() + "/" + System.currentTimeMillis() + "." + StringUtils.getExtensionName((String)filename);
        }
        if (!StringUtils.isEmpty((String)baseDir)) {
            filename = baseDir + "/" + filename;
        }
        return filename;
    }

    public void assertAllowed(String remoteUrl, String[] allowedExtension, long maxSize) throws InvalidExtensionException, FileUploadBase.FileSizeLimitExceededException {
        String extension = FilenameUtils.getExtension((String)remoteUrl);
        if (allowedExtension != null && !this.isAllowedExtension(extension, allowedExtension)) {
            if (allowedExtension == IMAGE_EXTENSION) {
                throw new InvalidExtensionException.InvalidImageExtensionException(allowedExtension, extension, remoteUrl);
            }
            if (allowedExtension == FLASH_EXTENSION) {
                throw new InvalidExtensionException.InvalidFlashExtensionException(allowedExtension, extension, remoteUrl);
            }
            if (allowedExtension == MEDIA_EXTENSION) {
                throw new InvalidExtensionException.InvalidMediaExtensionException(allowedExtension, extension, remoteUrl);
            }
            throw new InvalidExtensionException(allowedExtension, extension, remoteUrl);
        }
    }

    public String extractFilename(MultipartFile file, String baseDir, boolean needDatePathAndRandomName) throws UnsupportedEncodingException {
        String filename;
        int slashIndex;
        if (!StringUtils.isEmpty((String)this.ossBaseDir)) {
            baseDir = !StringUtils.isEmpty((String)baseDir) ? this.ossBaseDir + "/" + baseDir : this.ossBaseDir;
        }
        if ((slashIndex = (filename = file.getOriginalFilename()).indexOf("/")) >= 0) {
            filename = filename.substring(slashIndex + 1);
        }
        if (needDatePathAndRandomName) {
            filename = this.datePath() + "/" + System.currentTimeMillis() + "." + StringUtils.getExtensionName((String)filename);
        }
        if (!StringUtils.isEmpty((String)baseDir)) {
            filename = baseDir + "/" + filename;
        }
        return filename;
    }

    private String datePath() {
        Date now = new Date();
        return DateFormatUtils.format((Date)now, (String)"yyyy/MM/dd");
    }

    public void assertAllowed(MultipartFile file, String[] allowedExtension, long maxSize) throws InvalidExtensionException, FileUploadBase.FileSizeLimitExceededException {
        String filename = file.getOriginalFilename();
        String extension = FilenameUtils.getExtension((String)file.getOriginalFilename());
        if (allowedExtension != null && !this.isAllowedExtension(extension, allowedExtension)) {
            if (allowedExtension == IMAGE_EXTENSION) {
                throw new InvalidExtensionException.InvalidImageExtensionException(allowedExtension, extension, filename);
            }
            if (allowedExtension == FLASH_EXTENSION) {
                throw new InvalidExtensionException.InvalidFlashExtensionException(allowedExtension, extension, filename);
            }
            if (allowedExtension == MEDIA_EXTENSION) {
                throw new InvalidExtensionException.InvalidMediaExtensionException(allowedExtension, extension, filename);
            }
            throw new InvalidExtensionException(allowedExtension, extension, filename);
        }
        long size = file.getSize();
        if (maxSize != -1L && size > maxSize) {
            throw new FileUploadBase.FileSizeLimitExceededException("not allowed upload upload", size, maxSize);
        }
    }

    public boolean isAllowedExtension(String extension, String[] allowedExtension) {
        for (String str : allowedExtension) {
            if (!str.trim().equalsIgnoreCase(extension.trim())) continue;
            return true;
        }
        return false;
    }

    public void delete(HttpServletRequest request, String filename) throws IOException {
        if (StringUtils.isEmpty((String)filename)) {
            return;
        }
        this.ossClient.delete(filename);
    }
}

