/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.mybatis.mvc.entity;

import com.ailikes.common.mvc.entity.AbstractEntity;
import com.ailikes.common.mvc.entity.tree.TreeNode;
import com.ailikes.common.utils.StringUtils;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.enums.FieldStrategy;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class TreeEntity<T>
extends AbstractEntity<String>
implements TreeNode<String>,
Serializable {
    @TableId(value="id", type=IdType.UUID)
    private String id;
    @TableField(value="name")
    private String name;
    @TableField(value="parent_id", strategy=FieldStrategy.IGNORED)
    private String parentId;
    @TableField(value="parent_ids", strategy=FieldStrategy.IGNORED)
    private String parentIds;
    @TableField(exist=false)
    private Boolean expanded = Boolean.FALSE;
    @TableField(exist=false)
    private Boolean loaded = Boolean.TRUE;
    @TableField(exist=false)
    private T parent;
    @TableField(exist=false)
    private boolean hasChildren;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentIds() {
        return this.parentIds;
    }

    public void setParentIds(String parentIds) {
        this.parentIds = parentIds;
    }

    public boolean isRoot() {
        return this.getParentId() == null || this.getParentId().equals("0") || this.getParentId().equals("");
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public Long getLevel() {
        if (this.parentIds == null) {
            return 0L;
        }
        String[] parentIdArr = this.parentIds.split("/");
        ArrayList<String> idsList = new ArrayList<String>();
        for (String id : parentIdArr) {
            if (StringUtils.isEmpty((String)id)) continue;
            idsList.add(id);
        }
        return idsList.size();
    }

    public Boolean isLeaf() {
        if (this.isHasChildren()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String makeSelfAsNewParentIds() {
        if (StringUtils.isEmpty((String)this.getParentIds())) {
            return this.getId() + this.getSeparator();
        }
        return this.getParentIds() + this.getId() + this.getSeparator();
    }

    public String getSeparator() {
        return "/";
    }

    public void setExpanded(Boolean expanded) {
        this.expanded = expanded;
    }

    public Boolean getExpanded() {
        return this.expanded;
    }

    public void setLoaded(Boolean loaded) {
        this.loaded = loaded;
    }

    public Boolean getLoaded() {
        return this.loaded;
    }

    public T getParent() {
        return this.parent;
    }

    public void setParent(T parent) {
        this.parent = parent;
    }

    public String[] makeTags() {
        return new String[0];
    }
}

