/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.mybatis.mvc.controller;

import com.ailikes.common.http.PageResponse;
import com.ailikes.common.mvc.entity.AbstractEntity;
import com.ailikes.common.mvc.entity.tree.BootstrapTreeHelper;
import com.ailikes.common.mvc.entity.tree.TreeSortUtil;
import com.ailikes.common.mybatis.mvc.controller.BaseCRUDController;
import com.ailikes.common.mybatis.mvc.service.ITreeCommonService;
import com.ailikes.common.mybatis.mvc.wrapper.EntityWrapper;
import com.ailikes.common.query.data.PropertyPreFilterable;
import com.ailikes.common.query.data.QueryPropertyPreFilter;
import com.ailikes.common.query.data.Queryable;
import com.ailikes.common.utils.ObjectUtils;
import com.ailikes.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class BaseTreeController<Entity extends AbstractEntity<ID>, ID extends Serializable>
extends BaseCRUDController<Entity, ID> {
    ITreeCommonService<Entity, ID> treeCommonService;

    @Autowired
    public void treeCommonService(ITreeCommonService<Entity, ID> treeCommonService) {
        this.treeCommonService = treeCommonService;
        this.setCommonService(treeCommonService);
    }

    @ResponseBody
    @RequestMapping(value={"treeData"})
    public void treeData(Queryable queryable, @RequestParam(value="nodeid", required=false, defaultValue="") ID nodeid, @RequestParam(value="async", required=false, defaultValue="false") boolean async, HttpServletRequest request, HttpServletResponse response) throws IOException {
        EntityWrapper<Class> entityWrapper = new EntityWrapper<Class>(this.entityClass);
        entityWrapper.setTableAlias("t.");
        List<Class> treeNodeList = null;
        if (!async) {
            treeNodeList = this.treeCommonService.selectTreeList(queryable, entityWrapper);
            TreeSortUtil.create().sort(treeNodeList).async(treeNodeList);
        } else {
            if (ObjectUtils.isNullOrEmpty(nodeid)) {
                entityWrapper.isNull("parentId");
            } else {
                entityWrapper.eq("parentId", nodeid);
            }
            treeNodeList = this.treeCommonService.selectTreeList(queryable, entityWrapper);
            TreeSortUtil.create().sync(treeNodeList);
        }
        QueryPropertyPreFilter propertyPreFilterable = new QueryPropertyPreFilter();
        propertyPreFilterable.addQueryProperty(new String[]{"id", "name", "expanded", "hasChildren", "leaf", "loaded", "level", "parentId"});
        SerializeFilter filter = propertyPreFilterable.constructFilter(this.entityClass);
        PageResponse pagejson = new PageResponse(treeNodeList);
        String content = JSON.toJSONString((Object)pagejson);
        StringUtils.printJson((HttpServletResponse)response, (String)content);
    }

    @RequestMapping(value={"ajaxTreeList"})
    private void ajaxTreeList(Queryable queryable, @RequestParam(value="nodeid", required=false, defaultValue="") ID nodeid, @RequestParam(value="async", required=false, defaultValue="false") boolean async, HttpServletRequest request, HttpServletResponse response, PropertyPreFilterable propertyPreFilterable) throws IOException {
        EntityWrapper<Class> entityWrapper = new EntityWrapper<Class>(this.entityClass);
        entityWrapper.setTableAlias("t");
        this.preAjaxList(queryable, entityWrapper, request, response);
        List<Class> treeNodeList = null;
        if (!async) {
            treeNodeList = this.treeCommonService.selectTreeList(queryable, entityWrapper);
            TreeSortUtil.create().sort(treeNodeList).async(treeNodeList);
        } else {
            if (ObjectUtils.isNullOrEmpty(nodeid)) {
                entityWrapper.isNull("parentId");
            } else {
                entityWrapper.eq("parentId", nodeid);
            }
            treeNodeList = this.treeCommonService.selectTreeList(queryable, entityWrapper);
            TreeSortUtil.create().sync(treeNodeList);
        }
        propertyPreFilterable.addQueryProperty(new String[]{"id", "expanded", "hasChildren", "leaf", "loaded", "level", "parentId"});
        SerializeFilter filter = propertyPreFilterable.constructFilter(this.entityClass);
        PageResponse pagejson = new PageResponse(treeNodeList);
        String content = JSON.toJSONString((Object)pagejson);
        StringUtils.printJson((HttpServletResponse)response, (String)content);
    }

    @RequestMapping(value={"bootstrapTreeData"})
    private void bootstrapTreeData(Queryable queryable, @RequestParam(value="nodeid", required=false, defaultValue="") ID nodeid, HttpServletRequest request, HttpServletResponse response, PropertyPreFilterable propertyPreFilterable) throws IOException {
        EntityWrapper<Class> entityWrapper = new EntityWrapper<Class>(this.entityClass);
        entityWrapper.setTableAlias("t.");
        List<Class> treeNodeList = this.treeCommonService.selectTreeList(queryable, entityWrapper);
        List bootstrapTreeNodes = BootstrapTreeHelper.create().sort(treeNodeList);
        propertyPreFilterable.addQueryProperty(new String[]{"text", "href", "tags", "nodes"});
        SerializeFilter filter = propertyPreFilterable.constructFilter(this.entityClass);
        String content = JSON.toJSONString((Object)bootstrapTreeNodes, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
        StringUtils.printJson((HttpServletResponse)response, (String)content);
    }
}

