/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.mybatis.mvc.controller;

import com.ailikes.common.http.PageResponse;
import com.ailikes.common.http.Response;
import com.ailikes.common.mvc.controller.BaseBeanController;
import com.ailikes.common.mvc.entity.AbstractEntity;
import com.ailikes.common.mybatis.mvc.service.ICommonService;
import com.ailikes.common.mybatis.mvc.wrapper.EntityWrapper;
import com.ailikes.common.query.data.PropertyPreFilterable;
import com.ailikes.common.query.data.Queryable;
import com.ailikes.common.query.utils.QueryableConvertUtils;
import com.ailikes.common.utils.ObjectUtils;
import com.ailikes.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class BaseCRUDController<Entity extends AbstractEntity<ID>, ID extends Serializable>
extends BaseBeanController<Entity> {
    protected ICommonService<Entity> commonService;

    @Autowired
    public void setCommonService(ICommonService<Entity> commonService) {
        this.commonService = commonService;
    }

    public Entity get(ID id) {
        if (!ObjectUtils.isNullOrEmpty(id)) {
            return (Entity)((AbstractEntity)this.commonService.selectById((Serializable)id));
        }
        return (Entity)((AbstractEntity)this.newModel());
    }

    public void preList(Model model, HttpServletRequest request, HttpServletResponse response) {
    }

    @RequestMapping(method={RequestMethod.GET})
    public String list(Model model, HttpServletRequest request, HttpServletResponse response) {
        this.preList(model, request, response);
        return this.display("list");
    }

    public void preAjaxList(Queryable queryable, EntityWrapper<Entity> entityWrapper, HttpServletRequest request, HttpServletResponse response) {
    }

    @RequestMapping(value={"ajaxList"}, method={RequestMethod.GET, RequestMethod.POST})
    private void ajaxList(Queryable queryable, PropertyPreFilterable propertyPreFilterable, HttpServletRequest request, HttpServletResponse response) throws IOException {
        EntityWrapper<Class> entityWrapper = new EntityWrapper<Class>(this.entityClass);
        this.preAjaxList(queryable, entityWrapper, request, response);
        propertyPreFilterable.addQueryProperty(new String[]{"id"});
        QueryableConvertUtils.convertQueryValueToEntityValue((Queryable)queryable, (Class)this.entityClass);
        SerializeFilter filter = propertyPreFilterable.constructFilter(this.entityClass);
        PageResponse pagejson = new PageResponse(this.commonService.list(queryable, entityWrapper));
        String content = JSON.toJSONString((Object)pagejson, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
        StringUtils.printJson((HttpServletResponse)response, (String)content);
    }

    public String showView(Entity entity, Model model, HttpServletRequest request, HttpServletResponse response) {
        return "";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public String _view(Model model, @PathVariable(value="id") ID id, HttpServletRequest request, HttpServletResponse response) {
        Entity entity = this.get(id);
        this.showUpdate(entity, model, request, response);
        model.addAttribute("data", entity);
        String showView = this.showView((AbstractEntity)this.newModel(), model, request, response);
        if (!StringUtils.isEmpty((String)showView)) {
            return this.display(showView);
        }
        return this.display("edit");
    }

    public void preEdit(Entity entity, Model model, HttpServletRequest request, HttpServletResponse response) {
    }

    public String showCreate(Entity entity, Model model, HttpServletRequest request, HttpServletResponse response) {
        return "";
    }

    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String _showCreate(Model model, HttpServletRequest request, HttpServletResponse response) {
        this.preEdit((AbstractEntity)this.newModel(), model, request, response);
        String creteaView = this.showCreate((AbstractEntity)this.newModel(), model, request, response);
        if (!model.containsAttribute("data")) {
            model.addAttribute("data", (Object)this.newModel());
        }
        if (!StringUtils.isEmpty((String)creteaView)) {
            return creteaView;
        }
        return this.display("edit");
    }

    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    @ResponseBody
    public Response create(Model model, @Valid @ModelAttribute(value="data") Entity entity, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return this.doSave(entity, request, response, result);
    }

    public String showUpdate(Entity entity, Model model, HttpServletRequest request, HttpServletResponse response) {
        return "";
    }

    @RequestMapping(value={"{id}/update"}, method={RequestMethod.GET})
    public String _showUpdate(@PathVariable(value="id") ID id, Model model, HttpServletRequest request, HttpServletResponse response) {
        Entity entity = this.get(id);
        this.preEdit(entity, model, request, response);
        model.addAttribute("data", entity);
        String updateView = this.showUpdate((AbstractEntity)this.newModel(), model, request, response);
        if (!StringUtils.isEmpty((String)updateView)) {
            return updateView;
        }
        return this.display("edit");
    }

    @RequestMapping(value={"{id}/update"}, method={RequestMethod.POST})
    @ResponseBody
    public Response update(Model model, @Valid @ModelAttribute(value="data") Entity entity, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return this.doSave(entity, request, response, result);
    }

    public void preSave(Entity entity, HttpServletRequest request, HttpServletResponse response) {
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public Response doSave(Entity entity, HttpServletRequest request, HttpServletResponse response, BindingResult result) {
        if (this.hasError((Serializable)entity, result)) {
            String errorMsg = this.errorMsg(result);
            if (!StringUtils.isEmpty((String)errorMsg)) {
                return Response.error((String)errorMsg);
            }
            return Response.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        try {
            this.preSave(entity, request, response);
            if (ObjectUtils.isNullOrEmpty((Object)entity.getId())) {
                this.commonService.insert(entity);
            } else {
                AbstractEntity oldEntity = (AbstractEntity)this.commonService.selectById((Serializable)entity.getId());
                BeanUtils.copyProperties(entity, (Object)oldEntity);
                this.commonService.insertOrUpdate(oldEntity);
            }
            this.afterSave(entity, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)("\u4fdd\u5b58\u5931\u8d25!<br />\u539f\u56e0:" + e.getMessage()));
        }
        return Response.ok((String)"\u4fdd\u5b58\u6210\u529f");
    }

    public void afterSave(Entity entity, HttpServletRequest request, HttpServletResponse response) {
    }

    @RequestMapping(value={"{id}/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Response delete(@PathVariable(value="id") ID id) {
        this.commonService.deleteById((Serializable)id);
        return Response.ok();
    }

    @RequestMapping(value={"batch/delete"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Response batchDelete(@RequestParam(value="ids", required=false) ID[] ids) {
        List<ID> idList = Arrays.asList(ids);
        this.commonService.deleteBatchIds(idList);
        return Response.ok((String)"\u5220\u9664\u6210\u529f");
    }
}

