/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.hibernate.mvc.parse;

import com.ailikes.common.hibernate.mvc.parse.QueryParse;
import com.ailikes.common.query.data.Condition;
import com.ailikes.common.query.data.Queryable;
import com.ailikes.common.query.data.Sort;
import com.ailikes.common.utils.ObjectUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class CriteriaParse
implements QueryParse<DetachedCriteria> {
    @Override
    public void parseCondition(DetachedCriteria criteria, Queryable queryable) {
        Condition condition = queryable.getCondition();
        if (condition != null) {
            for (Condition.Filter filter : condition) {
                Object value = filter.getValue();
                if (ObjectUtils.isNullOrEmpty((Object)value)) continue;
                Condition.Operator operator = filter.getOperator();
                String property = filter.getProperty();
                Object criterion = null;
                if (operator == Condition.Operator.custom) continue;
                if (operator == Condition.Operator.isNull) {
                    criterion = Restrictions.isNull((String)property);
                } else if (operator == Condition.Operator.isNotNull) {
                    criterion = Restrictions.isNotNull((String)property);
                } else if (operator == Condition.Operator.between) {
                    Object[] between = null;
                    between = value instanceof List ? ((List)value).toArray(new Object[((List)value).size()]) : (Object[])value;
                    if (between.length == 2) {
                        criterion = Restrictions.between((String)property, (Object)between[0], (Object)between[1]);
                    }
                } else if (operator.name().toUpperCase(Locale.US).contains("LIKE")) {
                    value = this.parseLike(filter);
                    criterion = operator.name().contains("NOT") ? Restrictions.not((Criterion)Restrictions.like((String)filter.getProperty(), (Object)value)) : Restrictions.like((String)filter.getProperty(), (Object)value);
                } else {
                    criterion = this.getCriterion(filter);
                }
                if (criterion == null) continue;
                criteria.add(criterion);
            }
        }
    }

    public Object parseLike(Condition.Filter filter) {
        String operatorStr = filter.getOperator().name().toUpperCase(Locale.US);
        Object value = filter.getValue();
        value = operatorStr.contains("PREFIX") ? "%" + value : (operatorStr.contains("SUFFIX") ? value + "%" : "%" + value + "%");
        return value;
    }

    public Criterion getCriterion(Condition.Filter filter) {
        try {
            Class<Restrictions> threadClazz = Restrictions.class;
            Method method = threadClazz.getMethod(filter.getOperator().name(), String.class, Object.class);
            SimpleExpression simpleExpression = (SimpleExpression)method.invoke(null, filter.getProperty(), filter.getValue());
            return simpleExpression;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void parseSort(DetachedCriteria target, Queryable queryable) {
        Sort sort = queryable.getPageable().getSort();
        if (sort != null) {
            for (Sort.Order order : sort) {
                if (order.getDirection() == Sort.Direction.DESC) {
                    target.addOrder(Order.desc((String)order.getProperty()));
                    continue;
                }
                if (order.getDirection() != Sort.Direction.ASC) continue;
                target.addOrder(Order.asc((String)order.getProperty()));
            }
        }
    }
}

