/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.hibernate.mvc.service.impl;

import com.ailikes.common.hibernate.mvc.dao.ICommonDao;
import com.ailikes.common.hibernate.mvc.dao.support.OrderHelper;
import com.ailikes.common.hibernate.mvc.parse.CriteriaParse;
import com.ailikes.common.hibernate.mvc.service.ICommonService;
import com.ailikes.common.query.data.Page;
import com.ailikes.common.query.data.PageImpl;
import com.ailikes.common.query.data.Pageable;
import com.ailikes.common.query.data.Queryable;
import com.ailikes.common.query.utils.QueryableConvertUtils;
import com.ailikes.common.utils.ReflectionUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonServiceImpl<T extends Serializable>
implements ICommonService<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ICommonDao commonDao;
    protected Class<T> entityClass = ReflectionUtils.getSuperGenericType(this.getClass());

    @Override
    public void save(T entity) {
        this.commonDao.save(entity);
    }

    @Override
    public void batchSave(List<T> entitys) {
        this.commonDao.batchSave(entitys);
    }

    @Override
    public void saveOrUpdate(T entity) {
        this.commonDao.saveOrUpdate(entity);
    }

    @Override
    public void update(T entity) {
        this.commonDao.update(entity);
    }

    @Override
    public void merge(T entity) {
        this.commonDao.merge(entity);
    }

    @Override
    public T load(Serializable id) {
        return (T)((Serializable)this.commonDao.load(id, this.entityClass));
    }

    @Override
    public T get(Serializable id) {
        return (T)((Serializable)this.commonDao.get(id, this.entityClass));
    }

    @Override
    public T get(String propertyName, Object value) {
        return (T)((Serializable)this.commonDao.get(propertyName, value, this.entityClass));
    }

    @Override
    public void delete(T entity) {
        this.commonDao.delete(entity);
    }

    @Override
    public void deleteById(Serializable id) {
        this.commonDao.deleteById(id, this.entityClass);
    }

    @Override
    public void batchDelete(List<T> entitys) {
        this.commonDao.batchDelete(entitys);
    }

    @Override
    public void batchDeleteById(List<?> ids) {
        for (Object id : ids) {
            this.commonDao.deleteById((Serializable)id, this.entityClass);
        }
    }

    @Override
    public void batchDeleteByProperty(String propertyName, Object value) {
        this.commonDao.batchDeleteByProperty(propertyName, value, this.entityClass);
    }

    @Override
    public int count() {
        return this.commonDao.count(this.entityClass);
    }

    @Override
    public List<T> list() {
        return this.commonDao.list(this.entityClass);
    }

    @Override
    public List<T> list(OrderHelper orderHelper) {
        return this.commonDao.list(this.entityClass, orderHelper);
    }

    @Override
    public List<T> list(int page, int rows, DetachedCriteria detachedCriteria) {
        return this.commonDao.list(page, rows, detachedCriteria);
    }

    @Override
    public Page<T> list(Pageable pageable, DetachedCriteria detachedCriteria) {
        Long total = this.commonDao.count(detachedCriteria);
        List<T> content = this.list(pageable.getPageNumber(), pageable.getPageSize(), detachedCriteria);
        return new PageImpl(content, pageable, total.longValue());
    }

    @Override
    public Page<T> list(Queryable queryable, DetachedCriteria detachedCriteria) {
        CriteriaParse queryParse = new CriteriaParse();
        QueryableConvertUtils.convertQueryValueToEntityValue((Queryable)queryable, this.entityClass);
        queryParse.parseCondition(detachedCriteria, queryable);
        Long total = this.commonDao.count(detachedCriteria);
        queryParse.parseSort(detachedCriteria, queryable);
        Pageable pageable = queryable.getPageable();
        List<T> content = this.list(pageable.getPageNumber(), pageable.getPageSize(), detachedCriteria);
        return new PageImpl(content, queryable.getPageable(), total.longValue());
    }

    @Override
    public List<T> listWithNoPage(Queryable queryable, DetachedCriteria detachedCriteria) {
        CriteriaParse queryParse = new CriteriaParse();
        QueryableConvertUtils.convertQueryValueToEntityValue((Queryable)queryable, this.entityClass);
        queryParse.parseCondition(detachedCriteria, queryable);
        queryParse.parseSort(detachedCriteria, queryable);
        return this.commonDao.list(detachedCriteria);
    }

    @Override
    public int updateByHql(String hql, Object ... params) {
        return this.commonDao.updateByHql(hql, params);
    }

    @Override
    public int updateByIndexHql(String hql, Object ... params) {
        HashMap<String, Object> alias = new HashMap<String, Object>();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                alias.put(i + 1 + "", params[i]);
            }
        }
        return this.updateByAliasHql(hql, alias);
    }

    @Override
    public int updateByAliasHql(String hql, Map<String, Object> alias) {
        return this.commonDao.updateByAliasHql(hql, alias);
    }

    @Override
    public int count(Criterion ... criterions) {
        return this.commonDao.count(this.entityClass, criterions);
    }

    @Override
    public List<T> listByCriterion(Criterion ... criterions) {
        return this.commonDao.listByCriterion(this.entityClass, criterions);
    }

    @Override
    public List<T> listByCriterion(OrderHelper orderHelper, Criterion ... criterions) {
        return this.commonDao.listByCriterion(this.entityClass, orderHelper, criterions);
    }

    @Override
    public List<T> listByCriterion(int page, int rows, Criterion ... criterions) {
        return this.commonDao.listByCriterion(page, rows, this.entityClass, criterions);
    }

    @Override
    public List<T> listByCriterion(OrderHelper orderHelper, int page, int rows, Criterion ... criterions) {
        return this.commonDao.listByCriterion(page, rows, this.entityClass, orderHelper, criterions);
    }

    @Override
    public Long countByHql(String hql, Object ... params) {
        return this.commonDao.countByHql(hql, params);
    }

    @Override
    public Long countByAliasHql(String hql, Map<String, Object> alias) {
        return this.commonDao.countByAliasHql(hql, alias);
    }

    @Override
    public List<T> listByHql(String hql, Object ... params) {
        return this.commonDao.listByHql(hql, params);
    }

    @Override
    public List<T> listByHql(String hql, int page, int rows, Object ... params) {
        return this.commonDao.listByHql(hql, page, rows, params);
    }

    @Override
    public List<T> listByAliasHql(String hql, Map<String, Object> alias) {
        return this.commonDao.listByAliasHql(hql, alias);
    }

    @Override
    public List<Map<String, Object>> listMapByHql(String hql, Object ... params) {
        return this.commonDao.listMapByHql(hql, params);
    }

    @Override
    public List<Map<String, Object>> listMapByAliasHql(String hql, Map<String, Object> alias) {
        return this.commonDao.listMapByAliasHql(hql, alias);
    }

    @Override
    public List<T> list(String propertyName, Object value) {
        return this.commonDao.list(propertyName, value, this.entityClass);
    }

    @Override
    public void executeSql(String sql, Object ... params) {
        this.commonDao.executeSql(sql, params);
    }

    @Override
    public void executeAliasSql(String sql, Map<String, Object> alias) {
        this.commonDao.executeAliasSql(sql, alias);
    }

    @Override
    public Integer countBySql(String sql, Object ... params) {
        return this.commonDao.countBySql(sql, params);
    }

    @Override
    public Integer countByAliasSql(String sql, Map<String, Object> alias) {
        return this.commonDao.countByAliasSql(sql, alias);
    }

    @Override
    public List<Map<String, Object>> listBySql(String sql, Object ... params) {
        return this.commonDao.listBySql(sql, params);
    }

    @Override
    public List<Map<String, Object>> listByAliasSql(String sql, Map<String, Object> alias) {
        return this.commonDao.listByAliasSql(sql, alias);
    }

    @Override
    public List<Map<String, Object>> listPageBySql(String sql, int page, int rows, Object ... params) {
        return this.commonDao.listPageBySql(sql, page, rows, params);
    }

    @Override
    public List<Map<String, Object>> listPageByAliasSql(String sql, int page, int rows, Map<String, Object> alias) {
        return this.commonDao.listPageByAliasSql(sql, page, rows, alias);
    }

    @Override
    public List<T> listEntityBySql(String sql, Object ... params) {
        return this.commonDao.listEntityBySql(sql, this.entityClass, params);
    }

    @Override
    public List<T> listEntityByAliasSql(String sql, Map<String, Object> alias) {
        return this.commonDao.listEntityByAliasSql(sql, this.entityClass, alias);
    }

    @Override
    public List<T> listPageEntityBySql(String sql, int page, int rows, Object ... params) {
        return this.commonDao.listPageEntityBySql(sql, page, rows, this.entityClass, params);
    }

    @Override
    public List<T> listPageEntityByAliasSql(String sql, int page, int rows, Map<String, Object> alias) {
        return this.commonDao.listPageEntityByAliasSql(sql, page, rows, this.entityClass, alias);
    }

    @Override
    public int updateByHqlQueryId(String queryId, Object ... params) {
        return this.commonDao.updateByHqlQueryId(queryId, params);
    }

    @Override
    public int updateByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        return this.commonDao.updateByAliasHqlQueryId(queryId, alias);
    }

    @Override
    public Long countByHqlQueryId(String queryId, Object ... params) {
        return this.commonDao.countByHqlQueryId(queryId, params);
    }

    @Override
    public Long countByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        return this.commonDao.countByAliasHqlQueryId(queryId, alias);
    }

    @Override
    public List<T> listByHqlQueryId(String queryId, Object ... params) {
        return this.commonDao.listByHqlQueryId(queryId, params);
    }

    @Override
    public List<T> listByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        return this.commonDao.listByAliasHqlQueryId(queryId, alias);
    }

    @Override
    public List<T> listByHqlQueryId(String queryId, int page, int rows, Object ... params) {
        return this.commonDao.listByHqlQueryId(queryId, page, rows, params);
    }

    @Override
    public List<Map<String, Object>> listMapByHqlQueryId(String queryId, Object ... params) {
        return this.commonDao.listMapByHqlQueryId(queryId, params);
    }

    @Override
    public List<Map<String, Object>> listMapByHqlQueryId(String queryId, int page, int rows, Object ... params) {
        return this.commonDao.listMapByHqlQueryId(queryId, page, rows, params);
    }

    @Override
    public List<Map<String, Object>> listMapByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        return this.commonDao.listMapByAliasHqlQueryId(queryId, alias);
    }

    @Override
    public List<Map<String, Object>> listMapByAliasHqlQueryId(String queryId, int page, int rows, Map<String, Object> alias) {
        return this.commonDao.listMapByAliasHqlQueryId(queryId, page, rows, alias);
    }

    @Override
    public void executeSqlQueryId(String queryId, Object ... params) {
        this.commonDao.executeSqlQueryId(queryId, params);
    }

    @Override
    public Integer countBySqlQueryId(String queryId, Object ... params) {
        return this.commonDao.countBySqlQueryId(queryId, params);
    }

    @Override
    public List<Map<String, Object>> listBySqlQueryId(String queryId, Object ... params) {
        return this.commonDao.listBySqlQueryId(queryId, params);
    }

    @Override
    public List<Map<String, Object>> listByAliasSqlQueryId(String queryId, Map<String, Object> alias) {
        return this.commonDao.listByAliasSqlQueryId(queryId, alias);
    }

    @Override
    public List<Map<String, Object>> listPageBySqlQueryId(String queryId, int page, int rows, Object ... params) {
        return this.commonDao.listPageBySqlQueryId(queryId, page, rows, params);
    }

    @Override
    public List<Map<String, Object>> listPageByAliasSqlQueryId(String queryId, int page, int rows, Map<String, Object> alias) {
        return this.commonDao.listPageByAliasSqlQueryId(queryId, page, rows, alias);
    }

    @Override
    public List<T> listEntityBySqlQueryId(String queryId, Object ... params) {
        return this.commonDao.listEntityBySqlQueryId(queryId, this.entityClass, params);
    }

    @Override
    public List<T> listEntityByAliasSqlQueryId(String queryId, Map<String, Object> alias) {
        return this.commonDao.listEntityByAliasSqlQueryId(queryId, this.entityClass, alias);
    }

    @Override
    public List<T> listPageEntityBySqlQueryId(String queryId, int page, int rows, Object ... params) {
        return this.commonDao.listPageEntityBySqlQueryId(queryId, page, rows, this.entityClass, params);
    }

    @Override
    public List<T> listPageEntityByAliasSqlQueryId(String queryId, int page, int rows, Map<String, Object> alias) {
        return this.commonDao.listPageEntityByAliasSqlQueryId(queryId, page, rows, this.entityClass, alias);
    }
}

