/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.hibernate.mvc.hibernate.dynamic.template;

import com.ailikes.common.hibernate.mvc.hibernate.dynamic.data.StatementType;
import com.ailikes.common.hibernate.mvc.hibernate.dynamic.exception.DynamicException;
import com.ailikes.common.hibernate.mvc.hibernate.dynamic.template.IncludeHqlDirective;
import com.ailikes.common.hibernate.mvc.hibernate.dynamic.template.IncludeSqlDirective;
import com.ailikes.common.hibernate.mvc.hibernate.dynamic.utils.Utils;
import com.ailikes.common.utils.EhCacheUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class TemplateToFragmentParser {
    private Configuration configuration;
    private static TemplateToFragmentParser templateToFragmentParser = new TemplateToFragmentParser();
    private Map<String, Template> templateCache = new HashMap<String, Template>();
    protected static final EhCacheUtil ehcacheUtil = new EhCacheUtil("dynamicCache");

    public static TemplateToFragmentParser getFragmentParser() {
        templateToFragmentParser = new TemplateToFragmentParser();
        return templateToFragmentParser;
    }

    public TemplateToFragmentParser() {
        this.configuration = new Configuration();
        this.configuration.setNumberFormat("#");
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        this.configuration.setTemplateLoader((TemplateLoader)stringLoader);
        this.configuration.setSharedVariable("include_hql", (TemplateModel)new IncludeHqlDirective());
        this.configuration.setSharedVariable("include_sql", (TemplateModel)new IncludeSqlDirective());
    }

    public String parse(String statementId, StatementType type, Map<String, Object> parameters) {
        try {
            String templateKey = Utils.getCacheKeyByType(statementId, type);
            Template template = null;
            if (this.templateCache.containsKey(templateKey)) {
                template = this.templateCache.get(templateKey);
            } else {
                String statement = ehcacheUtil.getString(templateKey);
                template = new Template(templateKey, (Reader)new StringReader(statement), this.configuration);
            }
            StringWriter stringWriter = new StringWriter();
            template.process(parameters, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new DynamicException(e);
        }
    }

    public String parseHql(String statementId, Map<String, Object> parameters) {
        return this.parse(statementId, StatementType.HQL_QUERY, parameters);
    }

    public String parseSql(String statementId, Map<String, Object> parameters) {
        return this.parse(statementId, StatementType.SQL_QUERY, parameters);
    }

    public String parseHql(String statementId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.parse(statementId, StatementType.HQL_QUERY, parameters);
    }

    public String parseSql(String statementId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.parse(statementId, StatementType.SQL_QUERY, parameters);
    }
}

