/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.hibernate.mvc.controller;

import com.ailikes.common.hibernate.mvc.controller.BaseCRUDController;
import com.ailikes.common.hibernate.mvc.service.ITreeCommonService;
import com.ailikes.common.http.PageResponse;
import com.ailikes.common.mvc.entity.AbstractEntity;
import com.ailikes.common.mvc.entity.tree.BootstrapTreeHelper;
import com.ailikes.common.mvc.entity.tree.TreeSortUtil;
import com.ailikes.common.query.data.PropertyPreFilterable;
import com.ailikes.common.query.data.QueryPropertyPreFilter;
import com.ailikes.common.query.data.Queryable;
import com.ailikes.common.utils.ObjectUtils;
import com.ailikes.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class BaseTreeController<Entity extends AbstractEntity<ID>, ID extends Serializable>
extends BaseCRUDController<Entity, ID> {
    ITreeCommonService<Entity, ID> treeCommonService;

    @Autowired
    public void treeCommonService(ITreeCommonService<Entity, ID> treeCommonService) {
        this.treeCommonService = treeCommonService;
        this.setCommonService(treeCommonService);
    }

    @ResponseBody
    @RequestMapping(value={"treeData"})
    public void treeData(Queryable queryable, @RequestParam(value="nodeid", required=false, defaultValue="") ID nodeid, @RequestParam(value="async", required=false, defaultValue="false") boolean async, HttpServletRequest request, HttpServletResponse response) throws IOException {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass((Class)this.entityClass);
        List treeNodeList = null;
        if (!async) {
            treeNodeList = this.commonService.listWithNoPage(queryable, detachedCriteria);
            TreeSortUtil.create().sort(treeNodeList).async(treeNodeList);
        } else {
            if (ObjectUtils.isNullOrEmpty(nodeid)) {
                detachedCriteria.add(Restrictions.isNull((String)"parentId"));
            } else {
                detachedCriteria.add((Criterion)Restrictions.eq((String)"parentId", nodeid));
            }
            treeNodeList = this.commonService.listWithNoPage(queryable, detachedCriteria);
            TreeSortUtil.create().sync(treeNodeList);
        }
        QueryPropertyPreFilter propertyPreFilterable = new QueryPropertyPreFilter();
        propertyPreFilterable.addQueryProperty(new String[]{"id", "name", "expanded", "hasChildren", "leaf", "loaded", "level", "parentId"});
        SerializeFilter filter = propertyPreFilterable.constructFilter(this.entityClass);
        PageResponse pagejson = new PageResponse(treeNodeList);
        String content = JSON.toJSONString((Object)pagejson, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
        StringUtils.printJson((HttpServletResponse)response, (String)content);
    }

    @RequestMapping(value={"ajaxTreeList"}, method={RequestMethod.GET})
    private void ajaxTreeList(Queryable queryable, @RequestParam(value="nodeid", required=false, defaultValue="") ID nodeid, @RequestParam(value="async", required=false, defaultValue="false") boolean async, HttpServletRequest request, HttpServletResponse response, PropertyPreFilterable propertyPreFilterable) throws IOException {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass((Class)this.entityClass);
        this.preAjaxList(queryable, detachedCriteria, request, response);
        List treeNodeList = null;
        if (!async) {
            treeNodeList = this.commonService.listWithNoPage(queryable, detachedCriteria);
            TreeSortUtil.create().sort(treeNodeList).async(treeNodeList);
        } else {
            if (ObjectUtils.isNullOrEmpty(nodeid)) {
                detachedCriteria.add(Restrictions.isNull((String)"parentId"));
            } else {
                detachedCriteria.add((Criterion)Restrictions.eq((String)"parentId", nodeid));
            }
            treeNodeList = this.commonService.listWithNoPage(queryable, detachedCriteria);
            TreeSortUtil.create().sync(treeNodeList);
        }
        propertyPreFilterable.addQueryProperty(new String[]{"id", "expanded", "hasChildren", "leaf", "loaded", "level", "parentId"});
        SerializeFilter filter = propertyPreFilterable.constructFilter(this.entityClass);
        PageResponse pagejson = new PageResponse(treeNodeList);
        String content = JSON.toJSONString((Object)pagejson, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
        StringUtils.printJson((HttpServletResponse)response, (String)content);
    }

    @RequestMapping(value={"bootstrapTreeData"})
    private void bootstrapTreeData(Queryable queryable, @RequestParam(value="nodeid", required=false, defaultValue="") ID nodeid, HttpServletRequest request, HttpServletResponse response, PropertyPreFilterable propertyPreFilterable) throws IOException {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass((Class)this.entityClass);
        List treeNodeList = this.commonService.listWithNoPage(queryable, detachedCriteria);
        List bootstrapTreeNodes = BootstrapTreeHelper.create().sort(treeNodeList);
        propertyPreFilterable.addQueryProperty(new String[]{"text", "href", "tags", "nodes"});
        SerializeFilter filter = propertyPreFilterable.constructFilter(this.entityClass);
        String content = JSON.toJSONString((Object)bootstrapTreeNodes, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
        StringUtils.printJson((HttpServletResponse)response, (String)content);
    }
}

