/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.hibernate.mvc.service.impl;

import com.ailikes.common.hibernate.mvc.service.ITreeCommonService;
import com.ailikes.common.hibernate.mvc.service.impl.CommonServiceImpl;
import com.ailikes.common.mvc.entity.tree.TreeNode;
import com.ailikes.common.utils.ObjectUtils;
import com.ailikes.common.utils.ReflectionUtils;
import java.io.Serializable;
import java.util.List;

public class TreeCommonServiceImpl<T extends Serializable & TreeNode<ID>, ID extends Serializable>
extends CommonServiceImpl<T>
implements ITreeCommonService<T, ID> {
    private final String DELETE_CHILDREN_QL;
    private final String UPDATE_CHILDREN_PARENT_IDS_QL;

    protected TreeCommonServiceImpl() {
        Class entityClass = ReflectionUtils.getSuperGenericType(this.getClass());
        String entityName = entityClass.getName();
        this.DELETE_CHILDREN_QL = String.format("delete from %s where id=?1 or parentIds like concat(?2, %s)", entityName, "'%'");
        this.UPDATE_CHILDREN_PARENT_IDS_QL = String.format("update %s set parentIds=(?1 || substring(parentIds, length(?2)+1,length(parentIds)+1)) where parentIds like concat(?2, %s)", entityName, "'%'");
    }

    @Override
    public void save(T entity) {
        if (!ObjectUtils.isNullOrEmpty((Object)((TreeNode)entity).getParentId())) {
            Object parent = this.get((Serializable)((TreeNode)entity).getParentId());
            ((TreeNode)entity).setParentId(((TreeNode)parent).getId());
            ((TreeNode)entity).setParentIds(((TreeNode)parent).makeSelfAsNewParentIds());
        } else {
            ((TreeNode)entity).setParentId(null);
        }
        super.save(entity);
    }

    @Override
    public void update(T entity) {
        if (!ObjectUtils.isNullOrEmpty((Object)((TreeNode)entity).getParentId())) {
            Object parent = this.get((Serializable)((TreeNode)entity).getParentId());
            ((TreeNode)entity).setParentId(((TreeNode)parent).getId());
            ((TreeNode)entity).setParentIds(((TreeNode)parent).makeSelfAsNewParentIds());
            this.updateSelftAndChild(entity, (Serializable)((TreeNode)parent).getId(), ((TreeNode)parent).makeSelfAsNewParentIds());
        } else {
            ((TreeNode)entity).setParentId(null);
            this.updateSelftAndChild(entity, null, null);
        }
    }

    @Override
    public void delete(T entity) {
        this.updateByIndexHql(this.DELETE_CHILDREN_QL, ((TreeNode)entity).getId(), ((TreeNode)entity).makeSelfAsNewParentIds());
    }

    @Override
    public void deleteById(Serializable id) {
        Serializable treeId = id;
        Object entity = this.get(treeId);
        this.delete(entity);
    }

    @Override
    public void batchDeleteById(List<?> ids) {
        for (Object id : ids) {
            Serializable treeId = (Serializable)id;
            Object entity = this.get(treeId);
            this.delete(entity);
        }
    }

    private void updateSelftAndChild(T source, ID newParentId, String newParentIds) {
        String oldSourceChildrenParentIds = ((TreeNode)source).makeSelfAsNewParentIds();
        ((TreeNode)source).setParentId(newParentId);
        ((TreeNode)source).setParentIds(newParentIds);
        super.update(source);
        String newSourceChildrenParentIds = ((TreeNode)source).makeSelfAsNewParentIds();
        Class entityClass = ReflectionUtils.getSuperGenericType(this.getClass());
        String entityName = entityClass.getName();
        this.updateByIndexHql(this.UPDATE_CHILDREN_PARENT_IDS_QL, newSourceChildrenParentIds, oldSourceChildrenParentIds);
    }
}

