/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.hibernate.mvc.hibernate.dynamic.builder;

import com.ailikes.common.hibernate.mvc.hibernate.dynamic.builder.DynamicHibernateStatementBuilder;
import com.ailikes.common.hibernate.mvc.hibernate.dynamic.data.StatementType;
import com.ailikes.common.hibernate.mvc.hibernate.dynamic.exception.DynamicException;
import com.ailikes.common.hibernate.mvc.hibernate.dynamic.resolver.DynamicStatementDTDEntityResolver;
import com.ailikes.common.hibernate.mvc.hibernate.dynamic.utils.Utils;
import com.ailikes.common.utils.EhCacheUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.internal.util.xml.MappingReader;
import org.hibernate.internal.util.xml.Origin;
import org.hibernate.internal.util.xml.OriginImpl;
import org.hibernate.internal.util.xml.XmlDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DefaultDynamicHibernateStatementBuilder
implements DynamicHibernateStatementBuilder,
ResourceLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDynamicHibernateStatementBuilder.class);
    protected static final EhCacheUtil ehcacheUtil = new EhCacheUtil("dynamicCache");
    private String[] fileNames = new String[0];
    private ResourceLoader resourceLoader;
    private EntityResolver entityResolver = new DynamicStatementDTDEntityResolver();
    private Set<String> nameCache = new HashSet<String>();

    public void setFileNames(String[] fileNames) {
        this.fileNames = fileNames;
    }

    @Override
    public void init() throws IOException {
        this.nameCache.clear();
        ehcacheUtil.removeAll();
        boolean flag = this.resourceLoader instanceof ResourcePatternResolver;
        for (String file : this.fileNames) {
            if (flag) {
                Resource[] resources = ((ResourcePatternResolver)this.resourceLoader).getResources(file);
                this.buildMap(resources);
                continue;
            }
            Resource resource = ((ResourcePatternResolver)this.resourceLoader).getResource(file);
            this.buildMap(resource);
        }
        this.nameCache.clear();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private void buildMap(Resource[] resources) throws IOException {
        if (resources == null) {
            return;
        }
        for (Resource resource : resources) {
            this.buildMap(resource);
        }
    }

    private void buildMap(Resource resource) {
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(resource.getInputStream());
            XmlDocument metadataXml = MappingReader.INSTANCE.readMappingDocument(this.entityResolver, inputSource, (Origin)new OriginImpl("file", resource.getFilename()));
            if (DefaultDynamicHibernateStatementBuilder.isDynamicStatementXml(metadataXml)) {
                Document doc = metadataXml.getDocumentTree();
                Element dynamicHibernateStatement = doc.getRootElement();
                Iterator rootChildren = dynamicHibernateStatement.elementIterator();
                while (rootChildren.hasNext()) {
                    Element element = (Element)rootChildren.next();
                    String elementName = element.getName();
                    this.putStatementToCacheMap(resource, element, elementName);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            throw new DynamicException(e);
        }
        finally {
            if (inputSource != null && inputSource.getByteStream() != null) {
                try {
                    inputSource.getByteStream().close();
                }
                catch (IOException e) {
                    LOGGER.error(e.toString());
                    throw new DynamicException(e);
                }
            }
        }
    }

    private void putStatementToCacheMap(Resource resource, Element element, String statementNode) throws IOException {
        String statementId = element.attribute("id").getText();
        statementId = Utils.getCacheKeyByType(statementId, StatementType.fromString(statementNode));
        Validate.notEmpty((CharSequence)statementId);
        if (this.nameCache.contains(statementId)) {
            throw new DynamicException("\u91cd\u590d\u7684" + statementNode + "\u8bed\u53e5\u5b9a\u4e49\u5728\u6587\u4ef6:" + resource.getURI() + "\u4e2d\uff0c\u5fc5\u987b\u4fdd\u8bc1name\u7684\u552f\u4e00.");
        }
        this.nameCache.add(statementId);
        String queryText = element.getText().trim();
        ehcacheUtil.set(statementId, (Object)queryText);
    }

    private static boolean isDynamicStatementXml(XmlDocument xmlDocument) {
        return "mapper".equals(xmlDocument.getDocumentTree().getRootElement().getName());
    }
}

