/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.hibernate.mvc.hibernate.dynamic.adapter;

import com.ailikes.common.hibernate.mvc.hibernate.dynamic.adapter.IDynamicHibernateAdapter;
import com.ailikes.common.hibernate.mvc.hibernate.dynamic.template.TemplateToFragmentParser;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicHibernateAdapter
implements IDynamicHibernateAdapter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public final Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public void setParameters(Query query, Object[] params) {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i, params[i]);
            }
        }
    }

    @Override
    public int updateByHqlQueryId(String queryId, Object ... params) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId);
        Query query = this.getSession().createQuery(hql);
        this.setParameters(query, params);
        return query.executeUpdate();
    }

    @Override
    public int updateByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId);
        Query query = this.getSession().createQuery(hql);
        return query.executeUpdate();
    }

    @Override
    public Long countByHqlQueryId(String queryId, Object ... params) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId);
        Query query = this.getSession().createQuery(hql);
        this.setParameters(query, params);
        return (Long)query.uniqueResult();
    }

    @Override
    public Long countByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId);
        Query query = this.getSession().createQuery(hql);
        return (Long)query.uniqueResult();
    }

    @Override
    public <T> List<T> listByHqlQueryId(String queryId, Object ... params) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId);
        Query query = this.getSession().createQuery(hql);
        this.setParameters(query, params);
        return query.list();
    }

    @Override
    public <T> List<T> listByHqlQueryId(String queryId, int page, int rows, Object ... params) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId);
        Query query = this.getSession().createQuery(hql);
        this.setParameters(query, params);
        query.setFirstResult((page - 1) * rows);
        query.setMaxResults(rows);
        return query.list();
    }

    @Override
    public <T> List<T> listByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId, alias);
        Query query = this.getSession().createQuery(hql);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listMapByHqlQueryId(String queryId, Object ... params) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId);
        Query query = this.getSession().createQuery(hql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        this.setParameters(query, params);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listMapByHqlQueryId(String queryId, int page, int rows, Object ... params) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId);
        Query query = this.getSession().createQuery(hql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        this.setParameters(query, params);
        query.setMaxResults(rows);
        query.setFirstResult((page - 1) * rows);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listMapByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId, alias);
        Query query = this.getSession().createQuery(hql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listMapByAliasHqlQueryId(String queryId, int page, int rows, Map<String, Object> alias) {
        String hql = TemplateToFragmentParser.getFragmentParser().parseHql(queryId, alias);
        Query query = this.getSession().createQuery(hql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        query.setMaxResults(rows);
        query.setFirstResult((page - 1) * rows);
        return query.list();
    }

    @Override
    public void executeSqlQueryId(String queryId, Object ... params) {
        String sql = TemplateToFragmentParser.getFragmentParser().parseSql(queryId);
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setParameters((Query)query, params);
        query.executeUpdate();
    }

    @Override
    public Integer countBySqlQueryId(String queryId, Object ... params) {
        String sql = TemplateToFragmentParser.getFragmentParser().parseSql(queryId);
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setParameters((Query)query, params);
        BigInteger uniqueResult = (BigInteger)query.uniqueResult();
        return uniqueResult.intValue();
    }

    @Override
    public List<Map<String, Object>> listBySqlQueryId(String queryId, Object ... params) {
        String sql = TemplateToFragmentParser.getFragmentParser().parseSql(queryId);
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        this.setParameters((Query)query, params);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listPageBySqlQueryId(String queryId, int page, int rows, Object ... params) {
        String sql = TemplateToFragmentParser.getFragmentParser().parseSql(queryId);
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        this.setParameters((Query)query, params);
        query.setMaxResults(rows);
        query.setFirstResult((page - 1) * rows);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listByAliasSqlQueryId(String queryId, Map<String, Object> alias) {
        String sql = TemplateToFragmentParser.getFragmentParser().parseSql(queryId, alias);
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listPageByAliasSqlQueryId(String queryId, int page, int rows, Map<String, Object> alias) {
        String sql = TemplateToFragmentParser.getFragmentParser().parseSql(queryId, alias);
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        query.setMaxResults(rows);
        query.setFirstResult((page - 1) * rows);
        return query.list();
    }

    @Override
    public <T> List<T> listEntityBySqlQueryId(String queryId, Class<T> entityClass, Object ... params) {
        String sql = TemplateToFragmentParser.getFragmentParser().parseSql(queryId);
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setParameters((Query)query, params);
        query.addEntity(entityClass);
        return query.list();
    }

    @Override
    public <T> List<T> listPageEntityBySqlQueryId(String queryId, int page, int rows, Class<T> entityClass, Object ... params) {
        String sql = TemplateToFragmentParser.getFragmentParser().parseSql(queryId);
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setParameters((Query)query, params);
        query.addEntity(entityClass);
        query.setMaxResults(rows);
        query.setFirstResult((page - 1) * rows);
        return query.list();
    }

    @Override
    public <T> List<T> listPageEntityByAliasSqlQueryId(String queryId, int page, int rows, Class<T> entityClass, Map<String, Object> alias) {
        String sql = TemplateToFragmentParser.getFragmentParser().parseSql(queryId, alias);
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.addEntity(entityClass);
        query.setMaxResults(rows);
        query.setFirstResult((page - 1) * rows);
        return query.list();
    }

    @Override
    public <T> List<T> listEntityByAliasSqlQueryId(String queryId, Class<T> entityClass, Map<String, Object> alias) {
        String sql = TemplateToFragmentParser.getFragmentParser().parseSql(queryId, alias);
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.addEntity(entityClass);
        return query.list();
    }
}

