/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.hibernate.mvc.dao.impl;

import com.ailikes.common.hibernate.mvc.dao.ICommonDao;
import com.ailikes.common.hibernate.mvc.dao.ISqlDao;
import com.ailikes.common.hibernate.mvc.dao.impl.BaseDaoImpl;
import com.ailikes.common.hibernate.mvc.dao.support.OrderHelper;
import com.ailikes.common.hibernate.mvc.entity.MarkDeleteable;
import com.ailikes.common.hibernate.mvc.hibernate.dynamic.adapter.IDynamicHibernateAdapter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository(value="commonDao")
public class CommonDaoImpl
extends BaseDaoImpl
implements ICommonDao,
ISqlDao,
IDynamicHibernateAdapter {
    @Autowired
    private ISqlDao sqlDao;
    @Autowired
    private IDynamicHibernateAdapter dynamicHibernateAdapter;

    private <T> Criteria createCriteria(Class<T> entityClass, Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        for (Criterion c : criterions) {
            criteria.add(c);
        }
        return criteria;
    }

    @Override
    public <T> void save(T entity) {
        Assert.notNull(entity);
        try {
            this.getSession().save(entity);
            this.getSession().flush();
        }
        catch (RuntimeException e) {
            this.logger.error("\u6dfb\u52a0\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void batchSave(List<T> entitys) {
        Assert.notNull(entitys);
        for (int i = 0; i < entitys.size(); ++i) {
            this.getSession().save(entitys.get(i));
            if (i % 20 != 0) continue;
            this.getSession().flush();
            this.getSession().clear();
        }
        this.getSession().flush();
        this.getSession().clear();
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        Assert.notNull(entity);
        try {
            this.getSession().saveOrUpdate(entity);
        }
        catch (RuntimeException e) {
            this.logger.error("\u6dfb\u52a0\u6216\u66f4\u65b0\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void update(T entity) {
        Assert.notNull(entity);
        try {
            this.getSession().update(entity);
        }
        catch (RuntimeException e) {
            this.logger.error("\u66f4\u65b0\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> T load(Serializable id, Class<T> entityClass) {
        Assert.notNull((Object)id);
        try {
            Object t = this.getSession().load(entityClass, id);
            return (T)t;
        }
        catch (RuntimeException e) {
            this.logger.error("\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> T get(Serializable id, Class<T> entityClass) {
        Assert.notNull((Object)id);
        try {
            Object t = this.getSession().get(entityClass, id);
            return (T)t;
        }
        catch (RuntimeException e) {
            this.logger.error("\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> T get(String propertyName, Object value, Class<T> entityClass) {
        Assert.hasText((String)propertyName);
        Assert.notNull((Object)value);
        try {
            Object t = this.createCriteria(entityClass, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).uniqueResult();
            return (T)t;
        }
        catch (RuntimeException e) {
            this.logger.error("\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void delete(T entity) {
        Assert.notNull(entity);
        try {
            if (entity instanceof MarkDeleteable) {
                MarkDeleteable markDeleteable = (MarkDeleteable)entity;
                if (markDeleteable.markStatus().booleanValue()) {
                    this.saveOrUpdate(entity);
                } else {
                    this.getSession().delete(entity);
                }
            } else {
                this.getSession().delete(entity);
            }
        }
        catch (RuntimeException e) {
            this.logger.error("\u5220\u9664\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void deleteById(Serializable id, Class<T> entityClass) {
        Assert.notNull((Object)id);
        try {
            this.delete(this.get(id, entityClass));
        }
        catch (RuntimeException e) {
            this.logger.error("\u5220\u9664\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void batchDeleteByProperty(String propertyName, Object value, Class<T> entityClass) {
        Assert.hasText((String)propertyName);
        Assert.notNull((Object)value);
        try {
            List list = this.createCriteria(entityClass, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).list();
            this.batchDelete(list);
        }
        catch (RuntimeException e) {
            this.logger.error("\u5220\u9664\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> void batchDelete(List<T> entitys) {
        for (int i = 0; i < entitys.size(); ++i) {
            this.delete(entitys.get(i));
            if (i % 20 != 0) continue;
            this.getSession().flush();
            this.getSession().clear();
        }
        this.getSession().flush();
        this.getSession().clear();
    }

    @Override
    public <T> Long count(DetachedCriteria detachedCriteria) {
        Criteria criteria = detachedCriteria.getExecutableCriteria(this.getSession());
        Long total = (Long)criteria.setProjection(Projections.rowCount()).uniqueResult();
        if (total == null) {
            total = 0L;
        }
        return total;
    }

    @Override
    public <T> boolean exists(Serializable id, Class<T> entityClass) {
        Assert.notNull((Object)id);
        try {
            this.getSession().get(entityClass, id);
            return false;
        }
        catch (RuntimeException e) {
            this.logger.error("\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> int count(Class<T> entityClass) {
        try {
            return this.createCriteria(entityClass, new Criterion[0]).list().size();
        }
        catch (RuntimeException e) {
            this.logger.error("\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> int count(Class<T> entityClass, Criterion ... criterions) {
        Long total;
        Criteria criteria = this.getSession().createCriteria(entityClass);
        if (criterions != null) {
            for (Criterion criterion : criterions) {
                if (criterion == null) continue;
                criteria.add(criterion);
            }
        }
        if ((total = (Long)criteria.setProjection(Projections.rowCount()).uniqueResult()) == null) {
            total = 0L;
        }
        return total.intValue();
    }

    @Override
    public <T> List<T> list(Class<T> entityClass) {
        Criteria criteria = this.createCriteria(entityClass, new Criterion[0]);
        return criteria.list();
    }

    @Override
    public <T> List<T> list(Class<T> entityClass, OrderHelper orderHelper) {
        Criteria criteria = this.createCriteria(entityClass, new Criterion[0]);
        for (Order order : orderHelper) {
            criteria.addOrder(order);
        }
        return criteria.list();
    }

    @Override
    public <T> List<T> list(int page, int rows, DetachedCriteria detachedCriteria) {
        Criteria criteria = detachedCriteria.getExecutableCriteria(this.getSession());
        criteria.setProjection(null);
        criteria.setFirstResult((page - 1) * rows);
        criteria.setMaxResults(rows);
        List content = criteria.list();
        return content;
    }

    @Override
    public <T> List<T> list(DetachedCriteria detachedCriteria) {
        Criteria criteria = detachedCriteria.getExecutableCriteria(this.getSession());
        criteria.setProjection(null);
        List content = criteria.list();
        return content;
    }

    public void setParameters(Query query, Object[] params) {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i, params[i]);
            }
        }
    }

    private void setAliasParameter(Query query, Map<String, Object> alias) {
        if (alias != null) {
            Set<String> keys = alias.keySet();
            for (String key : keys) {
                Object val = alias.get(key);
                if (val instanceof Collection) {
                    query.setParameterList(key, (Collection)val);
                    continue;
                }
                query.setParameter(key, val);
            }
        }
    }

    @Override
    public int updateByHql(String hql, Object ... params) {
        Query query = this.getSession().createQuery(hql);
        this.setParameters(query, params);
        return query.executeUpdate();
    }

    @Override
    public int updateByAliasHql(String hql, Map<String, Object> alias) {
        Query query = this.getSession().createQuery(hql);
        this.setAliasParameter(query, alias);
        return query.executeUpdate();
    }

    @Override
    public <T> List<T> listByCriterion(Class<T> entityClass, Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        if (criterions != null) {
            for (Criterion criterion : criterions) {
                if (criterion == null) continue;
                criteria.add(criterion);
            }
        }
        List list = criteria.list();
        return list;
    }

    @Override
    public <T> List<T> listByCriterion(Class<T> entityClass, OrderHelper orderHelper, Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        if (criterions != null) {
            for (Criterion criterion : criterions) {
                if (criterion == null) continue;
                criteria.add(criterion);
            }
        }
        for (Order order : orderHelper) {
            criteria.addOrder(order);
        }
        List list = criteria.list();
        return list;
    }

    @Override
    public <T> List<T> listByCriterion(int page, int rows, Class<T> entityClass, Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        if (criterions != null) {
            for (Criterion criterion : criterions) {
                if (criterion == null) continue;
                criteria.add(criterion);
            }
        }
        criteria.setFirstResult((page - 1) * rows);
        criteria.setMaxResults(rows);
        List list = criteria.list();
        return list;
    }

    @Override
    public <T> List<T> listByCriterion(int page, int rows, Class<T> entityClass, OrderHelper orderHelper, Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        if (criterions != null) {
            for (Criterion criterion : criterions) {
                if (criterion == null) continue;
                criteria.add(criterion);
            }
        }
        for (Order order : orderHelper) {
            criteria.addOrder(order);
        }
        criteria.setFirstResult((page - 1) * rows);
        criteria.setMaxResults(rows);
        return criteria.list();
    }

    @Override
    public Long countByHql(String hql, Object ... params) {
        Query query = this.getSession().createQuery(hql);
        this.setParameters(query, params);
        return (Long)query.uniqueResult();
    }

    @Override
    public Long countByAliasHql(String hql, Map<String, Object> alias) {
        Query query = this.getSession().createQuery(hql);
        this.setAliasParameter(query, alias);
        return (Long)query.uniqueResult();
    }

    @Override
    public <T> List<T> listByHql(String hql, Object ... params) {
        Query query = this.getSession().createQuery(hql);
        this.setParameters(query, params);
        return query.list();
    }

    @Override
    public <T> List<T> listByAliasHql(String hql, int page, int rows, Map<String, Object> alias) {
        Query query = this.getSession().createQuery(hql);
        this.setAliasParameter(query, alias);
        return query.list();
    }

    @Override
    public <T> List<T> listByHql(String hql, int page, int rows, Object ... params) {
        Query query = this.getSession().createQuery(hql);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i, params[i]);
            }
        }
        query.setFirstResult((page - 1) * rows);
        query.setMaxResults(rows);
        return query.list();
    }

    @Override
    public <T> List<T> listByAliasHql(String hql, Map<String, Object> alias) {
        Query query = this.getSession().createQuery(hql);
        this.setAliasParameter(query, alias);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listMapByHql(String hql, Object ... params) {
        Query query = this.getSession().createQuery(hql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i, params[i]);
            }
        }
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listMapByAliasHql(String hql, Map<String, Object> alias) {
        Query query = this.getSession().createQuery(hql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        this.setAliasParameter(query, alias);
        return query.list();
    }

    @Override
    public <T> void merge(T entity) {
        this.getSession().merge(entity);
    }

    @Override
    public <T> List<T> list(String propertyName, Object value, Class<T> entityClass) {
        Assert.hasText((String)propertyName);
        Assert.notNull((Object)value);
        try {
            return this.createCriteria(entityClass, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).list();
        }
        catch (RuntimeException e) {
            this.logger.error("\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void executeSql(String sql, Object ... params) {
        this.sqlDao.executeSql(sql, params);
    }

    @Override
    public void executeAliasSql(String sql, Map<String, Object> alias) {
        this.sqlDao.executeAliasSql(sql, alias);
    }

    @Override
    public Integer countBySql(String sql, Object ... params) {
        return this.sqlDao.countBySql(sql, params);
    }

    @Override
    public Integer countByAliasSql(String sql, Map<String, Object> alias) {
        return this.sqlDao.countByAliasSql(sql, alias);
    }

    @Override
    public List<Map<String, Object>> listBySql(String sql, Object ... params) {
        return this.sqlDao.listBySql(sql, params);
    }

    @Override
    public List<Map<String, Object>> listByAliasSql(String sql, Map<String, Object> alias) {
        return this.sqlDao.listByAliasSql(sql, alias);
    }

    @Override
    public List<Map<String, Object>> listPageBySql(String sql, int page, int rows, Object ... params) {
        return this.sqlDao.listPageBySql(sql, page, rows, params);
    }

    @Override
    public List<Map<String, Object>> listPageByAliasSql(String sql, int page, int rows, Map<String, Object> alias) {
        return this.sqlDao.listPageByAliasSql(sql, page, rows, alias);
    }

    @Override
    public <T> List<T> listEntityBySql(String sql, Class<T> entityClass, Object ... params) {
        return this.sqlDao.listEntityBySql(sql, entityClass, params);
    }

    @Override
    public <T> List<T> listPageEntityBySql(String sql, int page, int rows, Class<T> entityClass, Object ... params) {
        return this.sqlDao.listPageEntityBySql(sql, page, rows, entityClass, params);
    }

    @Override
    public <T> List<T> listEntityByAliasSql(String sql, Class<T> entityClass, Map<String, Object> alias) {
        return this.sqlDao.listEntityByAliasSql(sql, entityClass, alias);
    }

    @Override
    public <T> List<T> listPageEntityByAliasSql(String sql, int page, int rows, Class<T> entityClass, Map<String, Object> alias) {
        return this.sqlDao.listPageEntityByAliasSql(sql, page, rows, entityClass, alias);
    }

    @Override
    public int updateByHqlQueryId(String queryId, Object ... params) {
        return this.dynamicHibernateAdapter.updateByHqlQueryId(queryId, params);
    }

    @Override
    public Long countByHqlQueryId(String queryId, Object ... params) {
        return this.dynamicHibernateAdapter.countByHqlQueryId(queryId, params);
    }

    @Override
    public <T> List<T> listByHqlQueryId(String queryId, Object ... params) {
        return this.dynamicHibernateAdapter.listByHqlQueryId(queryId, params);
    }

    @Override
    public <T> List<T> listByHqlQueryId(String queryId, int page, int rows, Object ... params) {
        return this.dynamicHibernateAdapter.listByHqlQueryId(queryId, page, rows, params);
    }

    @Override
    public <T> List<T> listByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        return this.dynamicHibernateAdapter.listByAliasHqlQueryId(queryId, alias);
    }

    @Override
    public List<Map<String, Object>> listMapByHqlQueryId(String queryId, Object ... params) {
        return this.dynamicHibernateAdapter.listMapByHqlQueryId(queryId, params);
    }

    @Override
    public List<Map<String, Object>> listMapByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        return this.dynamicHibernateAdapter.listMapByAliasHqlQueryId(queryId, alias);
    }

    @Override
    public void executeSqlQueryId(String queryId, Object ... params) {
        this.dynamicHibernateAdapter.executeSqlQueryId(queryId, params);
    }

    @Override
    public Integer countBySqlQueryId(String queryId, Object ... params) {
        return this.dynamicHibernateAdapter.countBySqlQueryId(queryId, params);
    }

    @Override
    public List<Map<String, Object>> listBySqlQueryId(String queryId, Object ... params) {
        return this.dynamicHibernateAdapter.listBySqlQueryId(queryId, params);
    }

    @Override
    public List<Map<String, Object>> listByAliasSqlQueryId(String queryId, Map<String, Object> alias) {
        return this.dynamicHibernateAdapter.listByAliasSqlQueryId(queryId, alias);
    }

    @Override
    public List<Map<String, Object>> listPageBySqlQueryId(String queryId, int page, int rows, Object ... params) {
        return this.dynamicHibernateAdapter.listPageBySqlQueryId(queryId, page, rows, params);
    }

    @Override
    public List<Map<String, Object>> listPageByAliasSqlQueryId(String queryId, int page, int rows, Map<String, Object> alias) {
        return this.dynamicHibernateAdapter.listPageByAliasSqlQueryId(queryId, page, rows, alias);
    }

    @Override
    public <T> List<T> listEntityBySqlQueryId(String queryId, Class<T> entityClass, Object ... params) {
        return this.dynamicHibernateAdapter.listEntityBySqlQueryId(queryId, entityClass, params);
    }

    @Override
    public <T> List<T> listEntityByAliasSqlQueryId(String queryId, Class<T> entityClass, Map<String, Object> alias) {
        return this.dynamicHibernateAdapter.listEntityByAliasSqlQueryId(queryId, entityClass, alias);
    }

    @Override
    public <T> List<T> listPageEntityBySqlQueryId(String queryId, int page, int rows, Class<T> entityClass, Object ... params) {
        return this.dynamicHibernateAdapter.listPageEntityBySqlQueryId(queryId, page, rows, entityClass, params);
    }

    @Override
    public <T> List<T> listPageEntityByAliasSqlQueryId(String queryId, int page, int rows, Class<T> entityClass, Map<String, Object> alias) {
        return this.dynamicHibernateAdapter.listPageEntityByAliasSqlQueryId(queryId, page, rows, entityClass, alias);
    }

    @Override
    public int updateByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        return this.dynamicHibernateAdapter.updateByAliasHqlQueryId(queryId, alias);
    }

    @Override
    public Long countByAliasHqlQueryId(String queryId, Map<String, Object> alias) {
        return this.dynamicHibernateAdapter.countByAliasHqlQueryId(queryId, alias);
    }

    @Override
    public List<Map<String, Object>> listMapByHqlQueryId(String queryId, int page, int rows, Object ... params) {
        return this.dynamicHibernateAdapter.listMapByHqlQueryId(queryId, page, rows, params);
    }

    @Override
    public List<Map<String, Object>> listMapByAliasHqlQueryId(String queryId, int page, int rows, Map<String, Object> alias) {
        return this.dynamicHibernateAdapter.listMapByAliasHqlQueryId(queryId, page, rows, alias);
    }
}

