/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.rest.util;

import cn.hutool.core.date.DateUtil;
import com.ailikes.common.form.base.api.constant.BaseStatusCode;
import com.ailikes.common.form.base.api.constant.ColumnType;
import com.ailikes.common.form.base.api.constant.IStatusCode;
import com.ailikes.common.form.base.api.exception.BusinessMessage;
import com.ailikes.common.form.base.api.query.FieldLogic;
import com.ailikes.common.form.base.api.query.FieldRelation;
import com.ailikes.common.form.base.api.query.QueryOP;
import com.ailikes.common.form.base.core.encrypt.Base64;
import com.ailikes.common.form.base.core.util.BeanCopierUtils;
import com.ailikes.common.form.base.core.util.BeanUtils;
import com.ailikes.common.form.base.core.util.StringUtil;
import com.ailikes.common.form.base.db.model.query.DefaultFieldLogic;
import com.ailikes.common.form.base.db.model.query.DefaultQueryField;
import com.ailikes.common.form.base.db.model.query.DefaultQueryFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class RequestUtil {
    public static String getRQString(HttpServletRequest request, String key, String errorMsg) {
        String result = RequestUtil.getString(request, key, null);
        if (result == null) {
            throw new BusinessMessage(String.format("[%s] %s", key, errorMsg), (IStatusCode)BaseStatusCode.PARAM_ILLEGAL);
        }
        return result;
    }

    public static String getString(HttpServletRequest request, String key, String defaultValue, boolean b) {
        String value = request.getParameter(key);
        if (StringUtil.isEmpty((String)value)) {
            return defaultValue;
        }
        if (b) {
            return value.replace("'", "''").trim();
        }
        return value.trim();
    }

    public static String getString(HttpServletRequest request, String key) {
        return RequestUtil.getString(request, key, "", true);
    }

    public static String getString(HttpServletRequest request, String key, boolean b) {
        return RequestUtil.getString(request, key, "", b);
    }

    public static String getString(HttpServletRequest request, String key, String defaultValue) {
        return RequestUtil.getString(request, key, defaultValue, true);
    }

    public static String getStringAry(HttpServletRequest request, String key) {
        String[] aryValue = request.getParameterValues(key);
        if (aryValue == null || aryValue.length == 0) {
            return "";
        }
        String tmp = "";
        for (String v : aryValue) {
            tmp = "".equals(tmp) ? tmp + v : tmp + "," + v;
        }
        return tmp;
    }

    public static String getSecureString(HttpServletRequest request, String key, String defaultValue) {
        String value = request.getParameter(key);
        if (StringUtil.isEmpty((String)value)) {
            return defaultValue;
        }
        return RequestUtil.filterInject(value);
    }

    public static String getSecureString(HttpServletRequest request, String key) {
        return RequestUtil.getSecureString(request, key, "");
    }

    public static String filterInject(String str) {
        String injectstr = "\\||;|exec|insert|select|delete|update|count|chr|truncate|char";
        Pattern regex = Pattern.compile(injectstr, 226);
        Matcher matcher = regex.matcher(str);
        str = matcher.replaceAll("");
        str = str.replace("'", "''");
        str = str.replace("-", "\u2014");
        str = str.replace("(", "\uff08");
        str = str.replace(")", "\uff09");
        str = str.replace("%", "\uff05");
        return str;
    }

    public static String getLowercaseString(HttpServletRequest request, String key) {
        return RequestUtil.getString(request, key).toLowerCase();
    }

    public static int getInt(HttpServletRequest request, String key) {
        return RequestUtil.getInt(request, key, 0);
    }

    public static int getInt(HttpServletRequest request, String key, int defaultValue) {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    public static long getLong(HttpServletRequest request, String key) {
        return RequestUtil.getLong(request, key, 0L);
    }

    public static Long[] getLongAry(HttpServletRequest request, String key) {
        String[] aryKey = request.getParameterValues(key);
        if (BeanUtils.isEmpty((Object)aryKey)) {
            return null;
        }
        Long[] aryLong = new Long[aryKey.length];
        for (int i = 0; i < aryKey.length; ++i) {
            aryLong[i] = Long.parseLong(aryKey[i]);
        }
        return aryLong;
    }

    public static Long[] getLongAryByStr(HttpServletRequest request, String key) {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return null;
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        String[] aryId = str.split(",");
        Long[] lAryId = new Long[aryId.length];
        for (int i = 0; i < aryId.length; ++i) {
            lAryId[i] = Long.parseLong(aryId[i]);
        }
        return lAryId;
    }

    public static String[] getStringAryByStr(HttpServletRequest request, String key) {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return null;
        }
        String[] aryId = str.split(",");
        String[] lAryId = new String[aryId.length];
        for (int i = 0; i < aryId.length; ++i) {
            lAryId[i] = aryId[i];
        }
        return lAryId;
    }

    public static Integer[] getIntAry(HttpServletRequest request, String key) {
        String[] aryKey = request.getParameterValues(key);
        if (BeanUtils.isEmpty((Object)aryKey)) {
            return null;
        }
        Integer[] aryInt = new Integer[aryKey.length];
        for (int i = 0; i < aryKey.length; ++i) {
            aryInt[i] = Integer.parseInt(aryKey[i]);
        }
        return aryInt;
    }

    public static Float[] getFloatAry(HttpServletRequest request, String key) {
        String[] aryKey = request.getParameterValues(key);
        if (BeanUtils.isEmpty((Object)aryKey)) {
            return null;
        }
        Float[] fAryId = new Float[aryKey.length];
        for (int i = 0; i < aryKey.length; ++i) {
            fAryId[i] = Float.valueOf(Float.parseFloat(aryKey[i]));
        }
        return fAryId;
    }

    public static long getLong(HttpServletRequest request, String key, long defaultValue) {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return defaultValue;
        }
        return Long.parseLong(str.trim());
    }

    public static Long getLong(HttpServletRequest request, String key, Long defaultValue) {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return defaultValue;
        }
        return Long.parseLong(str.trim());
    }

    public static float getFloat(HttpServletRequest request, String key) {
        return RequestUtil.getFloat(request, key, 0.0f);
    }

    public static float getFloat(HttpServletRequest request, String key, float defaultValue) {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return defaultValue;
        }
        return Float.parseFloat(request.getParameter(key));
    }

    public static boolean getBoolean(HttpServletRequest request, String key) {
        return RequestUtil.getBoolean(request, key, false);
    }

    public static boolean getBoolean(HttpServletRequest request, String key, boolean defaultValue) {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return defaultValue;
        }
        if (StringUtils.isNumeric((CharSequence)str)) {
            return Integer.parseInt(str) == 1;
        }
        return Boolean.parseBoolean(str);
    }

    public static Short getShort(HttpServletRequest request, String key) {
        return RequestUtil.getShort(request, key, (short)0);
    }

    public static Short getShort(HttpServletRequest request, String key, Short defaultValue) {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return defaultValue;
        }
        return Short.parseShort(str);
    }

    public static Date getDate(HttpServletRequest request, String key, String style) throws ParseException {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return null;
        }
        if (StringUtil.isEmpty((String)style)) {
            style = "yyyy-MM-dd HH:mm:ss";
        }
        return DateUtil.parse((String)str, (String)style);
    }

    public static Date getDate(HttpServletRequest request, String key) throws ParseException {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return null;
        }
        return DateUtil.parseDate((String)str);
    }

    public static Date getTimestamp(HttpServletRequest request, String key) throws ParseException {
        String str = request.getParameter(key);
        if (StringUtil.isEmpty((String)str)) {
            return null;
        }
        return DateUtil.parseDateTime((String)str);
    }

    public static void handleRequestParam(HttpServletRequest request, DefaultQueryFilter queryFilter) {
        DefaultFieldLogic andFieldLogic = new DefaultFieldLogic(FieldRelation.AND);
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String[] aryParamKey;
            String value;
            String key = (String)paramNames.nextElement();
            String specialSplitKey = "$";
            if (key.contains("^")) {
                specialSplitKey = "^";
            }
            if (!key.contains(specialSplitKey) || StringUtil.isEmpty((String)(value = request.getParameter(key))) || (aryParamKey = key.split("\\" + specialSplitKey)).length != 2) continue;
            String columnName = aryParamKey[0];
            String condition = aryParamKey[1];
            String columnType = condition.substring(0, 1);
            if ("V".equals(columnType)) {
                columnType = ColumnType.VARCHAR.getKey();
            } else if ("N".equals(columnType)) {
                columnType = ColumnType.NUMBER.getKey();
            } else if ("D".equals(columnType)) {
                columnType = ColumnType.DATE.getKey();
            }
            if (condition.length() == 1) {
                queryFilter.addParamsFilter(columnName, BeanUtils.getValue((String)columnType, (String)value));
                continue;
            }
            QueryOP queryOP = QueryOP.getByVal((String)condition.substring(1, condition.length()));
            andFieldLogic.getWhereClauses().add(new DefaultQueryField(columnName, queryOP, BeanUtils.getValue((String)columnType, (QueryOP)queryOP, (String)value)));
        }
        queryFilter.setFieldLogic((FieldLogic)andFieldLogic);
    }

    public static <T> Class<T> copyProperties(Class<T> source, Object target) {
        BeanCopierUtils.copyProperties(source, (Object)target);
        return source;
    }

    public static Map getParameterValueMap(HttpServletRequest request, boolean remainArray, boolean isSecure) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String key = params.nextElement().toString();
            String[] values = request.getParameterValues(key);
            if (values == null) continue;
            if (values.length == 1) {
                String tmpValue = values[0];
                if (tmpValue == null || (tmpValue = tmpValue.trim()).equals("")) continue;
                if (isSecure) {
                    tmpValue = RequestUtil.filterInject(tmpValue);
                }
                if (tmpValue.equals("")) continue;
                map.put(key, tmpValue);
                continue;
            }
            String rtn = RequestUtil.getByAry(values, isSecure);
            if (rtn.length() <= 0) continue;
            if (remainArray) {
                map.put(key, rtn.split(","));
                continue;
            }
            map.put(key, rtn);
        }
        return map;
    }

    private static String getByAry(String[] aryTmp, boolean isSecure) {
        String rtn = "";
        for (int i = 0; i < aryTmp.length; ++i) {
            String str = aryTmp[i].trim();
            if (str.equals("")) continue;
            if (isSecure) {
                if ((str = RequestUtil.filterInject(str)).equals("")) continue;
                rtn = rtn + str + ",";
                continue;
            }
            rtn = rtn + str + ",";
        }
        if (rtn.length() > 0) {
            rtn = rtn.substring(0, rtn.length() - 1);
        }
        return rtn;
    }

    public static String getStringValues(HttpServletRequest request, String paramName) {
        String[] values = request.getParameterValues(paramName);
        if (BeanUtils.isEmpty((Object)values)) {
            return "";
        }
        String tmp = "";
        for (int i = 0; i < values.length; ++i) {
            tmp = i == 0 ? tmp + values[i] : tmp + "," + values[i];
        }
        return tmp;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static void downLoadFileByByte(HttpServletRequest request, HttpServletResponse response, byte[] b, String fileName) throws IOException {
        ServletOutputStream outp = response.getOutputStream();
        if (b.length > 0) {
            response.setContentType("APPLICATION/OCTET-STREAM");
            String filedisplay = fileName;
            String agent = request.getHeader("USER-AGENT");
            if (agent != null && agent.indexOf("MSIE") == -1) {
                String enableFileName = "=?UTF-8?B?" + new String(Base64.getBase64((String)filedisplay)) + "?=";
                response.setHeader("Content-Disposition", "attachment; filename=" + enableFileName);
            } else {
                filedisplay = URLEncoder.encode(filedisplay, "utf-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
            }
            outp.write(b);
        } else {
            outp.write("\u6587\u4ef6\u4e0d\u5b58\u5728!".getBytes("utf-8"));
        }
        if (outp != null) {
            outp.close();
            outp = null;
            response.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoadFile(HttpServletRequest request, HttpServletResponse response, String fullPath, String fileName) throws IOException {
        ServletOutputStream outp = response.getOutputStream();
        File file = new File(fullPath);
        if (file.exists()) {
            response.setContentType("APPLICATION/OCTET-STREAM");
            String filedisplay = fileName;
            String agent = request.getHeader("USER-AGENT");
            if (agent != null && agent.indexOf("MSIE") == -1) {
                String enableFileName = "=?UTF-8?B?" + new String(Base64.getBase64((String)filedisplay)) + "?=";
                response.setHeader("Content-Disposition", "attachment; filename=" + enableFileName);
            } else {
                filedisplay = URLEncoder.encode(filedisplay, "utf-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
            }
            FileInputStream in = null;
            try {
                outp = response.getOutputStream();
                in = new FileInputStream(fullPath);
                byte[] b = new byte[1024];
                int i = 0;
                while ((i = in.read(b)) > 0) {
                    outp.write(b, 0, i);
                }
                outp.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    in.close();
                    in = null;
                }
                if (outp != null) {
                    outp.close();
                    outp = null;
                    response.flushBuffer();
                }
            }
        } else {
            outp.write("File does not exist!".getBytes("utf-8"));
        }
    }
}

