/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.rest.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;

public class IPAddressUtil {
    public static String getAddresses(String content) throws UnsupportedEncodingException {
        return IPAddressUtil.getAddresses("ip=" + content, "UTF-8");
    }

    private static String getAddresses(String content, String encodingString) throws UnsupportedEncodingException {
        String urlStr = "http://ip.taobao.com/service/getIpInfo.php";
        String returnStr = IPAddressUtil.getResult(urlStr, content, encodingString);
        if (returnStr != null) {
            String[] temp = returnStr.split(",");
            if (temp.length < 3) {
                return "0";
            }
            String region = temp[5].split(":")[1].replaceAll("\"", "");
            region = IPAddressUtil.decodeUnicode(region);
            String country = "";
            String area = "";
            String city = "";
            String county = "";
            String isp = "";
            block8: for (int i = 0; i < temp.length; ++i) {
                switch (i) {
                    case 1: {
                        country = temp[i].split(":")[2].replaceAll("\"", "");
                        country = IPAddressUtil.decodeUnicode(country);
                        continue block8;
                    }
                    case 3: {
                        area = temp[i].split(":")[1].replaceAll("\"", "");
                        area = IPAddressUtil.decodeUnicode(area);
                        continue block8;
                    }
                    case 5: {
                        region = temp[i].split(":")[1].replaceAll("\"", "");
                        region = IPAddressUtil.decodeUnicode(region);
                        continue block8;
                    }
                    case 7: {
                        city = temp[i].split(":")[1].replaceAll("\"", "");
                        city = IPAddressUtil.decodeUnicode(city);
                        continue block8;
                    }
                    case 9: {
                        county = temp[i].split(":")[1].replaceAll("\"", "");
                        county = IPAddressUtil.decodeUnicode(county);
                        continue block8;
                    }
                    case 11: {
                        isp = temp[i].split(":")[1].replaceAll("\"", "");
                        isp = IPAddressUtil.decodeUnicode(isp);
                    }
                }
            }
            return region;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResult(String urlStr, String content, String encoding) {
        URL url = null;
        HttpURLConnection connection = null;
        try {
            url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.writeBytes(content);
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    public static String decodeUnicode(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed  encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public static void main(String[] args) {
        String ip = "219.134.241.202";
        String address = "";
        try {
            address = IPAddressUtil.getAddresses(ip);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println(address);
    }
}

