/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.rest.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    public static final int DEFAULT_TIME_OUT = 60000;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static Logger log = LoggerFactory.getLogger(HttpClientUtil.class);

    public static String sendHttpRequest(String url, Map<String, String> paramMap, String charset, boolean isPost) {
        return HttpClientUtil.sendHttpRequest(url, paramMap, charset, isPost, 60000);
    }

    public static String sendHttpRequest(String url, Map<String, String> paramMap, String charset, boolean isPost, int timeout) {
        if (isPost) {
            return HttpClientUtil.httpPost(url, paramMap, charset, timeout);
        }
        return HttpClientUtil.httpGet(url, paramMap, charset, timeout);
    }

    public static String httpPost(String url, Map<String, String> params) {
        return HttpClientUtil.httpPost(url, params, DEFAULT_CHARSET, 60000);
    }

    public static String httpPost(String url, Map<String, String> params, String charset, int timeout) {
        log.error("http request url: " + url + " charset:" + charset + " timeout: " + timeout + " request str: " + params);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            pairs.add(new BasicNameValuePair(key, HttpClientUtil.formatStr(value)));
        }
        try {
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(pairs);
            return HttpClientUtil.httpPost(url, charset, timeout, (HttpEntity)httpEntity);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String httpPost(String url, String jsonStr) {
        return HttpClientUtil.httpPost(url, jsonStr, DEFAULT_CHARSET, 60000);
    }

    public static String httpPost(String url, String jsonStr, String charset, int timeout) {
        log.error("http request url: " + url + " charset:" + charset + " timeout: " + timeout + " request jsonStr: " + jsonStr);
        StringEntity httpEntity = null;
        try {
            httpEntity = new StringEntity(jsonStr, charset);
            return HttpClientUtil.httpPost(url, charset, timeout, (HttpEntity)httpEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String httpPost(String url, HttpEntity httpEntity) {
        return HttpClientUtil.httpPost(url, DEFAULT_CHARSET, 60000, httpEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, String charset, int timeout, HttpEntity httpEntity) {
        log.error("http url:" + url);
        if (url == null || url.equals("")) {
            return null;
        }
        String result = null;
        DefaultHttpClient httpClient = null;
        HttpPost httpPost = null;
        String responseBody = null;
        HttpResponse httpResponse = null;
        try {
            BasicHttpParams httpParams = new BasicHttpParams();
            httpParams.setParameter("http.connection.timeout", (Object)timeout);
            httpClient = new DefaultHttpClient((HttpParams)httpParams);
            httpPost = new HttpPost(url);
            httpPost.setEntity(httpEntity);
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = httpResponse.getEntity();
            result = responseBody = EntityUtils.toString((HttpEntity)entity, (String)charset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.getConnectionManager().shutdown();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.error("http return:" + result);
        return result;
    }

    public static String httpGet(String url, Map<String, String> params) {
        return HttpClientUtil.httpGet(url, params, DEFAULT_CHARSET, 60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url, Map<String, String> params, String charset, int timeout) {
        DefaultHttpClient httpClient = null;
        try {
            BasicHttpParams httpParams = new BasicHttpParams();
            httpParams.setParameter("http.connection.timeout", (Object)60000);
            httpClient = new DefaultHttpClient((HttpParams)httpParams);
            HttpEntity httpEntity = HttpClientUtil.httpGetEntity((HttpClient)httpClient, url, params, DEFAULT_CHARSET);
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)charset);
            return string;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.getConnectionManager().shutdown();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] httpGetBytes(String url, Map<String, String> params) {
        DefaultHttpClient httpClient = null;
        try {
            BasicHttpParams httpParams = new BasicHttpParams();
            httpParams.setParameter("http.connection.timeout", (Object)60000);
            httpClient = new DefaultHttpClient((HttpParams)httpParams);
            HttpEntity httpEntity = HttpClientUtil.httpGetEntity((HttpClient)httpClient, url, params, DEFAULT_CHARSET);
            byte[] byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
            return byArray;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.getConnectionManager().shutdown();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static HttpEntity httpGetEntity(HttpClient httpClient, String url, Map<String, String> params, String charset) {
        log.error("http request url: " + url + " charset:" + charset + " request str: " + params);
        if (url == null || url.equals("")) {
            return null;
        }
        HttpEntity entity = null;
        try {
            HttpGet httpGet;
            HttpResponse httpResponse;
            int statusCode;
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    pairs.add(new BasicNameValuePair(key, HttpClientUtil.formatStr(value)));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            if ((statusCode = (httpResponse = httpClient.execute((HttpUriRequest)(httpGet = new HttpGet(url)))).getStatusLine().getStatusCode()) != 200) {
                httpGet.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            entity = httpResponse.getEntity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    private static String formatStr(String text) {
        return null == text ? "" : text.trim();
    }
}

