/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.rest;

import com.ailikes.common.form.base.api.aop.annotion.CatchErr;
import com.ailikes.common.form.base.api.model.IDModel;
import com.ailikes.common.form.base.api.query.QueryFilter;
import com.ailikes.common.form.base.api.response.impl.ResultMsg;
import com.ailikes.common.form.base.core.util.StringUtil;
import com.ailikes.common.form.base.db.model.page.PageResult;
import com.ailikes.common.form.base.manager.Manager;
import com.ailikes.common.form.base.rest.GenericController;
import com.github.pagehelper.Page;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class BaseController<T extends IDModel>
extends GenericController {
    @Autowired
    Manager<String, T> manager;

    protected abstract String getModelDesc();

    @RequestMapping(value={"listJson"})
    public PageResult listJson(HttpServletRequest request, HttpServletResponse response) throws Exception {
        QueryFilter queryFilter = this.getQueryFilter(request);
        Page pageList = (Page)this.manager.query(queryFilter);
        return new PageResult((List)pageList);
    }

    @RequestMapping(value={"get"})
    @CatchErr
    public ResultMsg<T> get(@RequestParam String id) throws Exception {
        IDModel t = null;
        if (StringUtil.isNotEmpty((String)id)) {
            t = (IDModel)this.manager.get((Serializable)((Object)id));
        }
        return this.getSuccessResult(t);
    }

    @RequestMapping(value={"save"})
    @CatchErr
    public ResultMsg<String> save(@RequestBody T t) throws Exception {
        String desc;
        if (StringUtil.isEmpty((String)t.getId())) {
            desc = "\u6dfb\u52a0%s\u6210\u529f";
            this.manager.create(t);
        } else {
            this.manager.update(t);
            desc = "\u66f4\u65b0%s\u6210\u529f";
        }
        return this.getSuccessResult(String.format(desc, this.getModelDesc()));
    }

    @RequestMapping(value={"remove"})
    @CatchErr
    public ResultMsg<String> remove(@RequestParam String id) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)id);
        this.manager.removeByIds((Serializable[])aryIds);
        return this.getSuccessResult(String.format("\u5220\u9664%s\u6210\u529f", this.getModelDesc()));
    }
}

