/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.transaction;

import com.ailikes.common.form.base.core.util.AppUtil;
import com.ailikes.common.form.base.db.datasource.DataSourceUtil;
import com.ailikes.common.form.base.db.datasource.DbContextHolder;
import com.ailikes.common.form.base.db.datasource.DynamicDataSource;
import com.ailikes.common.form.base.db.transaction.AbDataSourceTransactionObject;
import com.ailikes.common.form.base.db.transaction.DataSourceTransactionObject;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class AbDataSourceTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private static Logger log = LoggerFactory.getLogger(AbDataSourceTransactionManager.class);
    private static ThreadLocal<AbDataSourceTransactionObject> threadLocalTopAbTxObject = new ThreadLocal();
    private static ThreadLocal<Boolean> transactionActive = new ThreadLocal();
    private boolean enforceReadOnly = false;

    public AbDataSourceTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public void setEnforceReadOnly(boolean enforceReadOnly) {
        this.enforceReadOnly = enforceReadOnly;
    }

    public boolean isEnforceReadOnly() {
        return this.enforceReadOnly;
    }

    public void afterPropertiesSet() throws Exception {
        log.debug("ab\u7684\u4e8b\u52a1\u7ba1\u7406\u5668\u5df2\u5c31\u7eea");
    }

    public Object getResourceFactory() {
        return DataSourceUtil.getDataSourceByAlias("dataSource");
    }

    protected Object doGetTransaction() {
        AbDataSourceTransactionObject abTxObject = new AbDataSourceTransactionObject();
        if (threadLocalTopAbTxObject.get() == null) {
            threadLocalTopAbTxObject.set(abTxObject);
            if (log.isDebugEnabled()) {
                log.debug("ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u4e3a\u9876\u5c42\u4e8b\u52a1\u5f00\u59cb\uff0c\u8c03\u7528AbDataSourceTransactionManager.addDataSource\u7684\u6570\u636e\u6e90\u5168\u90e8\u5f52\u4e8e\u8fd9\u91cc\u5904\u7406");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("\u8fdb\u5165ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]");
        }
        return abTxObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        if (transactionActive.get() == null) {
            return false;
        }
        return transactionActive.get();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        AbDataSourceTransactionObject abTxObject = (AbDataSourceTransactionObject)transaction;
        if (log.isDebugEnabled()) {
            log.debug("ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u5f00\u59cb");
        }
        abTxObject.setDefinition(definition);
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)AppUtil.getBean((String)"dataSource"));
        AbDataSourceTransactionManager.addGlobalDataSource("dataSource", (DataSource)((Object)dynamicDataSource), abTxObject);
        transactionActive.set(true);
    }

    private static void addGlobalDataSource(String dsKey, DataSource dataSource, AbDataSourceTransactionObject abTxObject) {
        try {
            DataSourceTransactionObject txObject = abTxObject.getDsTxObj(dsKey);
            if (txObject == null) {
                txObject = new DataSourceTransactionObject();
                abTxObject.putDsTxObj(dsKey, txObject);
            }
            if (!txObject.hasConnectionHolder() || txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
                ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)dataSource);
                if (conHolder != null) {
                    txObject.setConnectionHolder(conHolder, false);
                } else {
                    Connection newCon = dataSource.getConnection();
                    if (log.isDebugEnabled()) {
                        log.debug("\u5728ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u4e2d\uff0c\u6570\u636e\u6e90\u522b\u540d[" + dsKey + "]\u6253\u5f00\u8fde\u63a5\u6210\u529f");
                    }
                    txObject.setConnectionHolder(new ConnectionHolder(newCon), true);
                }
            }
            txObject.getConnectionHolder().setSynchronizedWithTransaction(true);
            Connection con = txObject.getConnectionHolder().getConnection();
            TransactionDefinition definition = abTxObject.getDefinition();
            Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)con, (TransactionDefinition)definition);
            txObject.setPreviousIsolationLevel(previousIsolationLevel);
            if (con.getAutoCommit()) {
                txObject.setMustRestoreAutoCommit(true);
                if (log.isDebugEnabled()) {
                    log.debug("\u5728ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u4e2d\uff0c\u8bbe\u7f6e\u6570\u636e\u6e90\u522b\u540d\u4e3a[" + dsKey + "]\u7684\u94fe\u63a5\u4e3a\u624b\u52a8\u63d0\u4ea4");
                }
                con.setAutoCommit(false);
            }
            AbDataSourceTransactionManager.prepareTransactionalConnection(con, definition);
            int timeout = AbDataSourceTransactionManager.staticDetermineTimeout(definition);
            if (timeout != -1) {
                txObject.getConnectionHolder().setTimeoutInSeconds(timeout);
            }
            if (txObject.isNewConnectionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)dataSource, (Object)txObject.getConnectionHolder());
            }
        }
        catch (Throwable ex) {
            DataSourceTransactionObject txObject = abTxObject.getDsTxObj(dsKey);
            if (txObject != null && txObject.isNewConnectionHolder()) {
                DataSource ds = DataSourceUtil.getDataSourceByAlias(dsKey);
                Connection con = txObject.getConnectionHolder().getConnection();
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
                txObject.setConnectionHolder(null, false);
            }
            throw new CannotCreateTransactionException("\u5728ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u4e2d\uff0c\u6570\u636e\u6e90\u522b\u540d[" + dsKey + "]\u6253\u5f00\u8fde\u63a5\u9519\u8bef", ex);
        }
    }

    public static void addDataSource(String dsKey, DataSource dataSource) {
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)AppUtil.getBean((String)"dataSource"));
        if (dataSource == dynamicDataSource) {
            return;
        }
        if (DbContextHolder.getDataSource().equals(dsKey) && TransactionSynchronizationManager.getResource((Object)dataSource) == null) {
            ConnectionHolder holder = threadLocalTopAbTxObject.get().getDsTxObj("dataSource").getConnectionHolder();
            TransactionSynchronizationManager.bindResource((Object)dataSource, (Object)holder);
            return;
        }
        if (threadLocalTopAbTxObject.get().getDsTxObjMap().containsKey(dsKey)) {
            return;
        }
        AbDataSourceTransactionManager.addGlobalDataSource(dsKey, dataSource, threadLocalTopAbTxObject.get());
    }

    protected Object doSuspend(Object transaction) {
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)AppUtil.getBean((String)"dataSource"));
        return TransactionSynchronizationManager.unbindResource((Object)((Object)dynamicDataSource));
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)AppUtil.getBean((String)"dataSource"));
        TransactionSynchronizationManager.bindResource((Object)((Object)dynamicDataSource), (Object)suspendedResources);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        AbDataSourceTransactionObject abTxObject = (AbDataSourceTransactionObject)status.getTransaction();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, DataSourceTransactionObject> entry : abTxObject.getDsTxObjMap().entrySet()) {
            try {
                entry.getValue().getConnectionHolder().getConnection().commit();
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(entry.getKey());
                if (!log.isDebugEnabled()) continue;
                log.debug("\u5728ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u4e2d\uff0c\u6570\u636e\u6e90\u522b\u540d[" + entry.getKey() + "]\u63d0\u4ea4\u4e8b\u52a1\u6210\u529f");
            }
            catch (SQLException ex) {
                throw new TransactionSystemException("\u6570\u636e\u6e90\u522b\u540d[" + entry.getKey() + "]\u63d0\u4ea4\u4e8b\u52a1\u5931\u8d25\uff0c\u9700\u8981\u5e72\u9884\u5df2\u63d0\u4ea4\u6210\u529f\u7684\u6570\u636e\u6e90\u522b\u540d[" + sb + "]\u7684\u6570\u636e", (Throwable)ex);
            }
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        AbDataSourceTransactionObject abTxObject = (AbDataSourceTransactionObject)status.getTransaction();
        for (Map.Entry<String, DataSourceTransactionObject> entry : abTxObject.getDsTxObjMap().entrySet()) {
            try {
                entry.getValue().getConnectionHolder().getConnection().rollback();
                if (!log.isDebugEnabled()) continue;
                log.debug("\u5728ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u4e2d\uff0c\u6570\u636e\u6e90\u522b\u540d[" + entry.getKey() + "]\u56de\u6eda\u4e8b\u52a1\u6210\u529f");
            }
            catch (SQLException ex) {
                throw new TransactionSystemException("\u6570\u636e\u6e90\u522b\u540d[" + entry.getKey() + "]\u56de\u6eda\u4e8b\u52a1\u5931\u8d25", (Throwable)ex);
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        AbDataSourceTransactionObject abTxObject = (AbDataSourceTransactionObject)status.getTransaction();
        for (Map.Entry<String, DataSourceTransactionObject> entry : abTxObject.getDsTxObjMap().entrySet()) {
            if (status.isDebug()) {
                log.debug("\u5728ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u4e2d\uff0c\u4fee\u6539\u6570\u636e\u522b\u540d\u4e3a [" + entry.getKey() + "]\u7684\u94fe\u63a5\u8d44\u6e90\u4e3a rollback-only");
            }
            entry.getValue().setRollbackOnly();
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        AbDataSourceTransactionObject abTxObject = (AbDataSourceTransactionObject)transaction;
        for (Map.Entry<String, DataSourceTransactionObject> entry : abTxObject.getDsTxObjMap().entrySet()) {
            DataSourceTransactionObject txObject = entry.getValue();
            DataSource dataSource = DataSourceUtil.getDataSourceByAliasWithLoacl(entry.getKey());
            if (txObject.isNewConnectionHolder()) {
                TransactionSynchronizationManager.unbindResource((Object)dataSource);
            }
            Connection con = txObject.getConnectionHolder().getConnection();
            try {
                if (txObject.isMustRestoreAutoCommit()) {
                    con.setAutoCommit(true);
                }
                DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (Integer)txObject.getPreviousIsolationLevel());
            }
            catch (Throwable ex) {
                log.debug("\u5728ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u4e2d\uff0c\u5728\u5b8c\u6210\u4e8b\u52a1\u540e\uff0c\u6570\u636e\u6e90\u522b\u540d\u4e3a[" + entry.getKey() + "]\u7684\u5c5e\u6027\u65e0\u6cd5\u88ab\u8fd8\u539f", ex);
            }
            if (txObject.isNewConnectionHolder()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5728ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u4e2d\uff0c\u5728\u5b8c\u6210\u4e8b\u52a1\u540e\uff0c\u91ca\u653e\u6570\u636e\u6e90\u522b\u540d\u4e3a[" + entry.getKey() + "]\u7684jdbc\u7684\u94fe\u63a5");
                }
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)dataSource);
            }
            txObject.getConnectionHolder().clear();
        }
        DataSource dataSource = DataSourceUtil.getDataSourceByAlias(DbContextHolder.getDataSource());
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)dataSource);
        if (conHolder != null) {
            TransactionSynchronizationManager.unbindResource((Object)dataSource);
        }
        if (abTxObject == threadLocalTopAbTxObject.get()) {
            threadLocalTopAbTxObject.remove();
            transactionActive.remove();
            if (log.isDebugEnabled()) {
                log.debug("ab\u4e8b\u52a1\u9876\u5c42\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u7ed3\u675f");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("ab\u4e8b\u52a1\u7f16\u53f7[" + abTxObject.getSerialNumber() + "]\u7ed3\u675f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareTransactionalConnection(Connection con, TransactionDefinition definition) throws SQLException {
        boolean isEnforceReadOnly = ((AbDataSourceTransactionManager)((Object)AppUtil.getBean(AbDataSourceTransactionManager.class))).isEnforceReadOnly();
        if (isEnforceReadOnly && definition.isReadOnly()) {
            try (Statement stmt = con.createStatement();){
                stmt.executeUpdate("SET TRANSACTION READ ONLY");
            }
        }
    }

    private static int staticDetermineTimeout(TransactionDefinition definition) {
        if (definition.getTimeout() != -1) {
            return definition.getTimeout();
        }
        AbDataSourceTransactionManager abTransactionManager = (AbDataSourceTransactionManager)((Object)AppUtil.getBean((String)"abTransactionManager"));
        return abTransactionManager.getDefaultTimeout();
    }
}

