/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.tableoper;

import com.ailikes.common.form.base.db.api.table.DbType;
import com.ailikes.common.form.base.db.model.table.Table;
import com.ailikes.common.form.base.db.tableoper.MysqlTableOperator;
import com.ailikes.common.form.base.db.tableoper.OracleTableOperator;
import com.ailikes.common.form.base.db.tableoper.TableOperator;
import org.springframework.jdbc.core.JdbcTemplate;

public class TableOperatorFactory {
    private TableOperatorFactory() {
    }

    public static TableOperator newOperator(String type, Table<?> table, JdbcTemplate jdbcTemplate) {
        if (DbType.MYSQL.equalsWithKey(type)) {
            return new MysqlTableOperator(table, jdbcTemplate);
        }
        if (DbType.ORACLE.equalsWithKey(type)) {
            return new OracleTableOperator(table, jdbcTemplate);
        }
        throw new RuntimeException("\u627e\u4e0d\u5230\u7c7b\u578b[" + type + "]\u7684\u6570\u636e\u5e93\u5904\u7406\u8005(TableOperator)");
    }
}

