/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.tableoper;

import com.ailikes.common.form.base.core.util.BeanUtils;
import com.ailikes.common.form.base.db.dboper.DbOperator;
import com.ailikes.common.form.base.db.dboper.DbOperatorFactory;
import com.ailikes.common.form.base.db.model.table.Column;
import com.ailikes.common.form.base.db.model.table.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class TableOperator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Table<? extends Column> table;
    protected JdbcTemplate jdbcTemplate;

    public TableOperator(Table<? extends Column> table, JdbcTemplate jdbcTemplate) {
        this.table = table;
        this.jdbcTemplate = jdbcTemplate;
    }

    public abstract String type();

    public void createTable() {
    }

    public void dropTable() {
        if (!this.isTableCreated()) {
            return;
        }
        String sql = "drop table " + this.table.getName() + "";
        this.jdbcTemplate.execute(sql);
    }

    public boolean isTableCreated() {
        return false;
    }

    public void addColumn(Column column) {
    }

    public void updateColumn(Column column) {
    }

    public void dropColumn(String columnName) {
    }

    public void insertData(Map<String, Object> data) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO " + this.table.getName());
        StringBuilder columnNameSql = new StringBuilder();
        StringBuilder paramNameSql = new StringBuilder();
        ArrayList<Object> param = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (columnNameSql.length() > 0) {
                columnNameSql.append(",");
                paramNameSql.append(",");
            }
            columnNameSql.append(entry.getKey());
            paramNameSql.append("?");
            param.add(entry.getValue());
        }
        sql.append("(" + columnNameSql + ") VALUES(" + paramNameSql + ")");
        this.jdbcTemplate.update(sql.toString(), param.toArray());
    }

    public void deleteData(Object id) {
        String sql = "DELETE FROM " + this.table.getName() + " where " + this.table.getPkColumn().getName() + " = ?";
        this.jdbcTemplate.update(sql, new Object[]{id});
    }

    public void deleteData(Map<String, Object> param) {
        if (param.isEmpty()) {
            throw new RuntimeException("\u64cd\u4f5c\u5220\u9664\u8868[" + this.table.getComment() + "(" + this.table.getName() + ")]\u65f6\uff0c\u6761\u4ef6\u53c2\u6570\u4e3a\u7a7a(\u4f1a\u5bfc\u81f4\u5168\u8868\u6570\u636e\u6e05\u7a7a)");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM " + this.table.getName() + " where ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (sql.toString().endsWith("?")) {
                sql.append(" and ");
            }
            sql.append(entry.getKey() + " = ?");
            paramList.add(entry.getValue());
        }
        this.jdbcTemplate.update(sql.toString(), paramList.toArray());
    }

    public void updateData(Map<String, Object> data) {
        Object id = data.get(this.table.getPkColumn().getName());
        if (BeanUtils.isEmpty((Object)id)) {
            throw new RuntimeException("\u64cd\u4f5c\u66f4\u65b0\u8868[" + this.table.getComment() + "(" + this.table.getName() + ")]\u65f6\uff0c\u53c2\u6570\u4e2d\u6709\u6ca1\u4e3b\u952e[" + this.table.getPkColumn().getComment() + "(" + this.table.getPkColumn().getName() + ")]");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE " + this.table.getName() + " SET ");
        ArrayList<Object> param = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getKey().equals(this.table.getPkColumn().getName())) continue;
            if (sql.toString().endsWith("?")) {
                sql.append(" , ");
            }
            param.add(entry.getValue());
            sql.append(entry.getKey() + " = ?");
        }
        sql.append(" WHERE " + this.table.getPkColumn().getName() + " = ?");
        param.add(id);
        this.jdbcTemplate.update(sql.toString(), param.toArray());
    }

    public Map<String, Object> selectData(List<String> columnName, Object id) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(this.table.getPkColumn().getName(), id);
        List<Map<String, Object>> list = this.selectData(columnName, param);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Map<String, Object> selectData(Object id) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(this.table.getPkColumn().getName(), id);
        List<Map<String, Object>> list = this.selectData(param);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public List<Map<String, Object>> selectData(Map<String, Object> param) {
        return this.selectData(null, param);
    }

    public List<Map<String, Object>> selectData(List<String> columnName, Map<String, Object> param) {
        StringBuilder sql = new StringBuilder();
        if (BeanUtils.isEmpty(columnName)) {
            sql.append("SELECT * FROM " + this.table.getName());
        } else {
            sql.append("SELECT");
            for (String cn : columnName) {
                if (!sql.toString().endsWith("SELECT")) {
                    sql.append(",");
                }
                sql.append(" " + cn);
            }
            sql.append(" FROM " + this.table.getName());
        }
        sql.append(" WHERE ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (sql.toString().endsWith("?")) {
                sql.append(" and ");
            }
            sql.append(entry.getKey() + " = ?");
            paramList.add(entry.getValue());
        }
        return this.jdbcTemplate.queryForList(sql.toString(), paramList.toArray());
    }

    public void syncColumn() {
        if (!this.isTableCreated()) {
            return;
        }
        HashSet<String> dbColumnNames = new HashSet<String>();
        for (Column column : this.getDbTable().getColumns()) {
            dbColumnNames.add(column.getName());
        }
        for (String string : dbColumnNames) {
            if (this.table.getColumn(string) != null) continue;
            this.dropColumn(string);
        }
        for (Column column : this.table.getColumns()) {
            if (dbColumnNames.contains(column.getName())) continue;
            this.addColumn(column);
        }
    }

    public Table<Column> getDbTable() {
        DbOperator dbOperator = DbOperatorFactory.newOperator(this.type(), this.jdbcTemplate);
        return dbOperator.getTable(this.table.getName());
    }
}

