/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.tableoper;

import com.ailikes.common.form.base.api.constant.ColumnType;
import com.ailikes.common.form.base.core.util.StringUtil;
import com.ailikes.common.form.base.db.api.table.DbType;
import com.ailikes.common.form.base.db.model.table.Column;
import com.ailikes.common.form.base.db.model.table.Table;
import com.ailikes.common.form.base.db.tableoper.TableOperator;
import org.springframework.jdbc.core.JdbcTemplate;

public class OracleTableOperator
extends TableOperator {
    public OracleTableOperator(Table<? extends Column> table, JdbcTemplate jdbcTemplate) {
        super(table, jdbcTemplate);
    }

    @Override
    public String type() {
        return DbType.ORACLE.getKey();
    }

    @Override
    public void createTable() {
        if (this.isTableCreated()) {
            this.logger.debug("\u8868[" + this.table.getName() + "(" + this.table.getComment() + ")]\u5df2\u5b58\u5728\u6570\u636e\u5e93\u4e2d\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210");
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE \"" + this.table.getName() + "\" (\n");
        for (Column column : this.table.getColumns()) {
            sql.append(this.columnToSql(column) + ",\n");
        }
        sql.append("PRIMARY KEY (\"" + ((Column)this.table.getPkColumn()).getName() + "\")\n)");
        this.jdbcTemplate.execute(sql.toString());
        if (StringUtil.isNotEmpty((String)this.table.getComment())) {
            String str = "COMMENT ON TABLE \"" + this.table.getName() + "\" IS '" + this.table.getComment() + "'";
            this.jdbcTemplate.execute(str);
        }
        for (int i = 0; i < this.table.getColumns().size(); ++i) {
            Column column;
            column = (Column)this.table.getColumns().get(i);
            if (StringUtil.isEmpty((String)column.getComment())) continue;
            String str = "COMMENT ON COLUMN \"" + this.table.getName() + "\".\"" + column.getName() + "\"  IS '" + column.getComment() + "'";
            this.jdbcTemplate.execute(str);
        }
    }

    @Override
    public boolean isTableCreated() {
        String sql = "select count(1) from user_tables t where table_name =?";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{this.table.getName()}) > 0;
    }

    @Override
    public void addColumn(Column column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE \"" + this.table.getName() + "\"");
        sql.append(" ADD ( " + this.columnToSql(column) + " )");
        this.jdbcTemplate.execute(sql.toString());
        if (StringUtil.isEmpty((String)column.getComment())) {
            return;
        }
        String str = "COMMENT ON COLUMN \"" + this.table.getName() + "\".\"" + column.getName() + "\"  IS '" + column.getComment() + "'";
        this.jdbcTemplate.execute(str);
    }

    @Override
    public void updateColumn(Column column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE \"" + this.table.getName() + "\"");
        sql.append(" MODIFY( " + this.columnToSql(column) + " )");
        this.jdbcTemplate.execute(sql.toString());
    }

    @Override
    public void dropColumn(String columnName) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE \"" + this.table.getName() + "\"");
        sql.append(" DROP(\"" + columnName + "\")");
        this.jdbcTemplate.execute(sql.toString());
    }

    private String columnToSql(Column column) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"" + column.getName() + "\"");
        if (ColumnType.CLOB.equalsWithKey(column.getType())) {
            sb.append(" CLOB");
        } else if (ColumnType.DATE.equalsWithKey(column.getType())) {
            sb.append(" TIMESTAMP");
        } else if (ColumnType.NUMBER.equalsWithKey(column.getType())) {
            sb.append(" NUMBER(" + column.getLength() + "," + column.getDecimal() + ")");
        } else if (ColumnType.VARCHAR.equalsWithKey(column.getType())) {
            sb.append(" VARCHAR2(" + column.getLength() + ")");
        }
        if (column.isRequired() || column.isPrimary()) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }
}

