/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.tableoper;

import com.ailikes.common.form.base.api.constant.ColumnType;
import com.ailikes.common.form.base.core.util.StringUtil;
import com.ailikes.common.form.base.db.api.table.DbType;
import com.ailikes.common.form.base.db.model.table.Column;
import com.ailikes.common.form.base.db.model.table.Table;
import com.ailikes.common.form.base.db.tableoper.TableOperator;
import org.springframework.jdbc.core.JdbcTemplate;

public class MysqlTableOperator
extends TableOperator {
    public MysqlTableOperator(Table<? extends Column> table, JdbcTemplate jdbcTemplate) {
        super(table, jdbcTemplate);
    }

    @Override
    public String type() {
        return DbType.MYSQL.getKey();
    }

    @Override
    public void createTable() {
        if (this.isTableCreated()) {
            this.logger.debug("\u8868[" + this.table.getName() + "(" + this.table.getComment() + ")]\u5df2\u5b58\u5728\u6570\u636e\u5e93\u4e2d\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210");
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE " + this.table.getName() + " (\n");
        for (Column column : this.table.getColumns()) {
            sql.append(this.columnToSql(column) + ",\n");
        }
        sql.append("PRIMARY KEY (" + ((Column)this.table.getPkColumn()).getName() + ")\n)");
        sql.append(" ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE utf8_bin ");
        if (StringUtil.isNotEmpty((String)this.table.getComment())) {
            sql.append(" COMMENT='" + this.table.getComment() + "'");
        }
        sql.append(";");
        this.jdbcTemplate.execute(sql.toString());
    }

    @Override
    public boolean isTableCreated() {
        String sql = "select count(1) from information_schema.TABLES t where table_name =?";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{this.table.getName()}) > 0;
    }

    @Override
    public void addColumn(Column column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE " + this.table.getName() + "");
        sql.append(" ADD COLUMN " + this.columnToSql(column) + ";");
        this.jdbcTemplate.execute(sql.toString());
    }

    @Override
    public void updateColumn(Column column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE " + this.table.getName() + "");
        sql.append(" MODIFY COLUMN " + this.columnToSql(column) + ";");
        this.jdbcTemplate.execute(sql.toString());
    }

    @Override
    public void dropColumn(String columnName) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE " + this.table.getName() + "");
        sql.append(" DROP COLUMN " + columnName + ";");
        this.jdbcTemplate.execute(sql.toString());
    }

    private String columnToSql(Column column) {
        StringBuilder sb = new StringBuilder();
        sb.append("" + column.getName() + "");
        if (ColumnType.CLOB.equalsWithKey(column.getType())) {
            sb.append(" text");
        } else if (ColumnType.DATE.equalsWithKey(column.getType())) {
            sb.append(" datetime");
        } else if (ColumnType.NUMBER.equalsWithKey(column.getType())) {
            sb.append(" decimal(" + column.getLength() + "," + column.getDecimal() + ")");
        } else if (ColumnType.VARCHAR.equalsWithKey(column.getType())) {
            sb.append(" varchar(" + column.getLength() + ")");
        }
        if (column.isRequired() || column.isPrimary()) {
            sb.append(" NOT NULL");
        } else {
            sb.append(" NULL");
        }
        if (StringUtil.isNotEmpty((String)column.getDefaultValue())) {
            sb.append(" DEFAULT " + column.getDefaultValue() + "");
        }
        sb.append(" COMMENT '" + column.getComment() + "'");
        return sb.toString();
    }
}

