/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.model.query;

import com.ailikes.common.form.base.api.Page;
import com.ailikes.common.form.base.api.query.Direction;
import com.ailikes.common.form.base.api.query.FieldLogic;
import com.ailikes.common.form.base.api.query.FieldSort;
import com.ailikes.common.form.base.api.query.QueryField;
import com.ailikes.common.form.base.api.query.QueryFilter;
import com.ailikes.common.form.base.api.query.QueryOP;
import com.ailikes.common.form.base.api.query.WhereClause;
import com.ailikes.common.form.base.db.model.query.DefaultFieldLogic;
import com.ailikes.common.form.base.db.model.query.DefaultFieldSort;
import com.ailikes.common.form.base.db.model.query.DefaultPage;
import com.ailikes.common.form.base.db.model.query.DefaultQueryField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultQueryFilter
implements QueryFilter {
    private Page page = new DefaultPage();
    private List<FieldSort> fieldSortList = new ArrayList<FieldSort>();
    private Map<String, Object> params = new LinkedHashMap<String, Object>();
    private FieldLogic fieldLogic = new DefaultFieldLogic();

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public Map<String, Object> getParams() {
        this.initParams(this.fieldLogic);
        return this.params;
    }

    public DefaultQueryFilter() {
    }

    public DefaultQueryFilter(FieldLogic fieldLogic) {
        this.fieldLogic = fieldLogic;
    }

    public FieldLogic getFieldLogic() {
        return this.fieldLogic;
    }

    public void setFieldLogic(FieldLogic fieldLogic) {
        this.fieldLogic = fieldLogic;
    }

    private void initParams(FieldLogic fedLog) {
        List list = fedLog.getWhereClauses();
        for (WhereClause clause : list) {
            if (clause instanceof QueryField) {
                QueryField queryField = (QueryField)clause;
                if (QueryOP.IS_NULL.equals((Object)queryField.getCompare()) || QueryOP.NOTNULL.equals((Object)queryField.getCompare())) continue;
                String fileNameString = queryField.getField();
                if (fileNameString.indexOf(".") > -1) {
                    fileNameString = fileNameString.substring(fileNameString.indexOf(".") + 1);
                }
                this.params.put(fileNameString, queryField.getValue());
                continue;
            }
            if (!(clause instanceof FieldLogic)) continue;
            FieldLogic fdTemp = (FieldLogic)clause;
            this.initParams(fdTemp);
        }
    }

    public List<FieldSort> getFieldSortList() {
        return this.fieldSortList;
    }

    public void setFieldSortList(List<FieldSort> fieldSortList) {
        this.fieldSortList = fieldSortList;
    }

    public void addFieldSort(String orderField, String orderSeq) {
        this.fieldSortList.add(new DefaultFieldSort(orderField, Direction.fromString((String)orderSeq)));
    }

    public void addFilter(String name, Object obj, QueryOP queryType) {
        this.fieldLogic.getWhereClauses().add(new DefaultQueryField(name, queryType, obj));
    }

    public void addParamsFilter(String key, Object obj) {
        this.params.put(key, obj);
    }

    public void addParams(Map<String, Object> params) {
        this.params.putAll(params);
    }

    public String getWhereSql() {
        String defaultWhere;
        String dynamicWhereSql = this.getFieldLogic().getSql();
        String string = defaultWhere = this.params.containsKey("defaultWhere") ? this.params.get("defaultWhere").toString() : "";
        if (StringUtils.isNotEmpty((CharSequence)defaultWhere)) {
            dynamicWhereSql = StringUtils.isNotEmpty((CharSequence)dynamicWhereSql) ? dynamicWhereSql + " and " + defaultWhere : defaultWhere;
        }
        return dynamicWhereSql;
    }

    public String getOrderBySql() {
        if (this.getFieldSortList().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (FieldSort fieldSort : this.getFieldSortList()) {
                sb.append(fieldSort.getField()).append(" ").append(fieldSort.getDirection()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }
}

