/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.model.query;

import cn.hutool.core.date.DateUtil;
import com.ailikes.common.form.base.api.query.QueryField;
import com.ailikes.common.form.base.api.query.QueryOP;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class DefaultQueryField
implements QueryField {
    private String field;
    private QueryOP compare;
    private Object value;

    public DefaultQueryField() {
    }

    public DefaultQueryField(String field, Object value) {
        this.field = field;
        this.value = value;
    }

    public DefaultQueryField(String field, QueryOP compare, Object value) {
        this.field = field;
        this.compare = compare;
        this.value = value;
        this.value = QueryOP.IN.equals((Object)compare) || QueryOP.NOT_IN.equals((Object)compare) ? this.getInValueSql() : value;
    }

    private String getInValueSql() {
        if (this.value instanceof String) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            StringTokenizer st = new StringTokenizer(this.value.toString(), ",");
            while (st.hasMoreTokens()) {
                sb.append("'");
                sb.append(st.nextToken());
                sb.append("'");
                sb.append(",");
            }
            sb = new StringBuilder(sb.substring(0, sb.length() - 1));
            sb.append(")");
            return sb.toString();
        }
        if (this.value instanceof List) {
            List objList = (List)this.value;
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (Object obj : objList) {
                sb.append("\"");
                sb.append(obj.toString());
                sb.append("\"");
                sb.append(",");
            }
            sb = new StringBuilder(sb.substring(0, sb.length() - 1));
            sb.append(")");
            return sb.toString();
        }
        return "";
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public QueryOP getCompare() {
        return this.compare;
    }

    public void setCompare(QueryOP compare) {
        this.compare = compare;
    }

    public String getSql() {
        if (this.compare == null) {
            this.compare = QueryOP.EQUAL;
        }
        String fieldParam = this.field.indexOf(".") > -1 ? "#{" + this.field.substring(this.field.indexOf(".") + 1) + "}" : "#{" + this.field + "}";
        String sql = this.field;
        if (sql.lastIndexOf("^") != -1) {
            sql = sql.substring(0, sql.lastIndexOf("^"));
        }
        switch (this.compare) {
            case EQUAL: {
                sql = sql + " = " + fieldParam;
                break;
            }
            case EQUAL_IGNORE_CASE: {
                sql = "upper(" + sql + ") = " + fieldParam;
                break;
            }
            case LESS: {
                sql = sql + " < " + fieldParam;
                break;
            }
            case LESS_EQUAL: {
                sql = "upper(" + sql + ") = " + fieldParam;
                break;
            }
            case GREAT: {
                sql = sql + " > " + fieldParam;
                break;
            }
            case GREAT_EQUAL: {
                sql = sql + " >= " + fieldParam;
                break;
            }
            case NOT_EQUAL: {
                sql = sql + " != " + fieldParam;
                break;
            }
            case LEFT_LIKE: {
                sql = sql + " like " + fieldParam;
                this.setValue("%" + String.valueOf(this.value));
                break;
            }
            case RIGHT_LIKE: {
                sql = sql + " like  " + fieldParam;
                this.setValue(String.valueOf(this.value) + "%");
                break;
            }
            case LIKE: {
                sql = sql + " like  " + fieldParam;
                this.setValue("%" + String.valueOf(this.value) + "%");
                break;
            }
            case IS_NULL: {
                sql = sql + " is null";
                break;
            }
            case IN: {
                sql = sql + " in  " + this.value;
                break;
            }
            case NOT_IN: {
                sql = sql + " not in  " + this.value;
                break;
            }
            default: {
                sql = sql + " =  " + fieldParam;
            }
        }
        return sql;
    }

    private String getBetweenSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(" between ");
        if (this.value instanceof List) {
            List objList = (List)this.value;
            for (int i = 0; i < objList.size(); ++i) {
                Object obj = objList.get(i);
                if (i == 1) {
                    sb.append(" and ");
                }
                if (obj instanceof Date) {
                    String dateString = DateUtil.format((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss");
                    sb.append("\"" + dateString + "\"");
                    continue;
                }
                sb.append("\"" + obj.toString() + "\"");
            }
        }
        sb.append(" ");
        return sb.toString();
    }
}

