/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.model.query;

import com.ailikes.common.form.base.api.Page;
import com.ailikes.common.form.base.api.query.FieldSort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.session.RowBounds;

public class DefaultPage
extends RowBounds
implements Page,
Serializable {
    private static final long serialVersionUID = -1718110184113189225L;
    public static final int NO_PAGE = 1;
    protected int pageNo = 1;
    protected int pageSize = 20;
    protected List<FieldSort> orders = new ArrayList<FieldSort>();
    protected boolean containsTotalCount = true;
    protected Boolean asyncTotalCount;
    private boolean isShowTotal = true;

    public DefaultPage() {
    }

    public DefaultPage(RowBounds rowBounds) {
        if (rowBounds instanceof DefaultPage) {
            DefaultPage pageBounds = (DefaultPage)rowBounds;
            this.pageNo = pageBounds.pageNo;
            this.pageSize = pageBounds.pageSize;
            this.orders = pageBounds.orders;
            this.containsTotalCount = pageBounds.containsTotalCount;
            this.asyncTotalCount = pageBounds.asyncTotalCount;
        } else {
            this.pageNo = rowBounds.getOffset() / rowBounds.getLimit() + 1;
            this.pageSize = rowBounds.getLimit();
        }
    }

    public DefaultPage(int limit) {
        this.pageSize = limit;
        this.containsTotalCount = false;
    }

    public DefaultPage(int page, int limit) {
        this(page, limit, new ArrayList<FieldSort>(), true);
    }

    public DefaultPage(List<FieldSort> orders) {
        this(1, Integer.MAX_VALUE, orders, false);
    }

    public DefaultPage(FieldSort ... order) {
        this(1, Integer.MAX_VALUE, order);
        this.containsTotalCount = false;
    }

    public DefaultPage(int page, int limit, FieldSort ... order) {
        this(page, limit, Arrays.asList(order), true);
    }

    public DefaultPage(int page, int limit, List<FieldSort> orders) {
        this(page, limit, orders, true);
    }

    public DefaultPage(int page, int limit, List<FieldSort> orders, boolean containsTotalCount) {
        this.pageNo = page;
        this.pageSize = limit;
        this.orders = orders;
        this.containsTotalCount = containsTotalCount;
    }

    public int getPage() {
        return this.pageNo;
    }

    public void setPage(int page) {
        this.pageNo = page;
    }

    public int getLimit() {
        return this.pageSize;
    }

    public void setLimit(int limit) {
        this.pageSize = limit;
    }

    public boolean isContainsTotalCount() {
        return this.containsTotalCount;
    }

    public void setContainsTotalCount(boolean containsTotalCount) {
        this.containsTotalCount = containsTotalCount;
    }

    public List<FieldSort> getOrders() {
        List<FieldSort> list = this.orders;
        return list;
    }

    public void setOrders(List<FieldSort> orders) {
        this.orders = orders;
    }

    public Boolean getAsyncTotalCount() {
        return this.asyncTotalCount;
    }

    public void setAsyncTotalCount(Boolean asyncTotalCount) {
        this.asyncTotalCount = asyncTotalCount;
    }

    public int getOffset() {
        if (this.pageNo >= 1) {
            return (this.pageNo - 1) * this.pageSize;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PageBounds{");
        sb.append("page=").append(this.pageNo);
        sb.append(", limit=").append(this.pageSize);
        sb.append(", orders=").append(this.orders);
        sb.append(", containsTotalCount=").append(this.containsTotalCount);
        sb.append(", asyncTotalCount=").append(this.asyncTotalCount);
        sb.append('}');
        return sb.toString();
    }

    public Integer getPageNo() {
        return this.getPage();
    }

    public Integer getPageSize() {
        return this.getLimit();
    }

    public Integer getStartIndex() {
        return this.getOffset();
    }

    public Integer getTotal() {
        throw new RuntimeException("total not support");
    }

    public void setShowTotal(boolean isShowTotal) {
        this.isShowTotal = isShowTotal;
    }

    public boolean isShowTotal() {
        return this.isShowTotal;
    }
}

