/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.model.query;

import com.ailikes.common.form.base.api.query.Direction;
import com.ailikes.common.form.base.api.query.FieldSort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DefaultFieldSort
implements FieldSort,
Serializable {
    private static final long serialVersionUID = 5742164735225460363L;
    private Direction direction;
    private String field;
    private static String INJECTION_REGEX = "[A-Za-z0-9\\_\\-\\+\\.]+";

    public DefaultFieldSort(String field) {
        this(field, Direction.ASC);
    }

    public DefaultFieldSort(String field, Direction direction) {
        this.direction = direction;
        this.field = field;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String getField() {
        return this.field;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setField(String field) {
        this.field = field;
    }

    public static boolean isSQLInjection(String str) {
        return !Pattern.matches(INJECTION_REGEX, str);
    }

    public String toString() {
        if (DefaultFieldSort.isSQLInjection(this.field)) {
            throw new IllegalArgumentException("SQLInjection property: " + this.field);
        }
        return this.field + (this.direction == null ? "" : " " + this.direction.name());
    }

    public static List<DefaultFieldSort> formString(String orderSegment) {
        if (orderSegment == null || orderSegment.trim().equals("")) {
            return new ArrayList<DefaultFieldSort>(0);
        }
        ArrayList<DefaultFieldSort> results = new ArrayList<DefaultFieldSort>();
        String[] orderSegments = orderSegment.trim().split(",");
        for (int i = 0; i < orderSegments.length; ++i) {
            String sortSegment = orderSegments[i];
            DefaultFieldSort order = DefaultFieldSort._formString(sortSegment);
            if (order == null) continue;
            results.add(order);
        }
        return results;
    }

    private static DefaultFieldSort _formString(String orderSegment) {
        if (orderSegment == null || orderSegment.trim().equals("")) {
            return null;
        }
        String[] array = orderSegment.trim().split("\\s+");
        if (array.length != 1 && array.length != 2) {
            throw new IllegalArgumentException("orderSegment pattern must be {property}.{direction}, input is: " + orderSegment);
        }
        return DefaultFieldSort.create(array[0], array.length == 2 ? array[1] : "asc");
    }

    public static DefaultFieldSort create(String property, String direction) {
        return new DefaultFieldSort(property, Direction.fromString((String)direction));
    }
}

