/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.dboper;

import com.ailikes.common.form.base.api.constant.ColumnType;
import com.ailikes.common.form.base.api.exception.BusinessException;
import com.ailikes.common.form.base.db.api.table.DbType;
import com.ailikes.common.form.base.db.dboper.DbOperator;
import com.ailikes.common.form.base.db.model.table.Column;
import com.ailikes.common.form.base.db.model.table.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class OracleDbOperator
extends DbOperator {
    public OracleDbOperator(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    @Override
    public String type() {
        return DbType.ORACLE.getKey();
    }

    @Override
    public Map<String, String> getTableNames(String tableName) {
        List list;
        String sql = "select t.table_name,f.comments from user_tables t inner join user_tab_comments f on t.table_name = f.table_name";
        if (StringUtils.isNotEmpty((CharSequence)tableName)) {
            sql = sql + " AND t.table_name LIKE ?";
            list = this.jdbcTemplate.queryForList(sql, new Object[]{"%" + tableName + "%"});
        } else {
            list = this.jdbcTemplate.queryForList(sql);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map m : list) {
            map.put(m.get("table_name").toString(), this.getOrDefault(m, "comments", "").toString());
        }
        return map;
    }

    @Override
    public List<String> getViewNames(String viewName) {
        String sql = "SELECT * FROM USER_VIEWS ";
        if (StringUtils.isNotEmpty((CharSequence)viewName)) {
            sql = sql + " WHERE VIEW_NAME LIKE ?";
        }
        ArrayList<String> list = new ArrayList<String>();
        List results = this.jdbcTemplate.queryForList(sql, new Object[]{"%" + viewName + "%"});
        for (Map line : results) {
            list.add(line.get("VIEW_NAME").toString());
        }
        return list;
    }

    @Override
    public Table<Column> getTable(String tableName) {
        Table<Column> table = new Table<Column>();
        Map<String, String> tableNames = this.getTableNames(tableName);
        if (tableNames.isEmpty()) {
            throw new BusinessException(String.format("\u6839\u636e\u8868\u540d[%s]\u83b7\u53d6\u4e0d\u5230\u8868", tableName));
        }
        table.setName(tableName);
        table.setComment(tableNames.get(tableName));
        table.setColumns(this.getColumns(tableName));
        return table;
    }

    @Override
    public Table<Column> getView(String viewName) {
        Table<Column> table = new Table<Column>();
        List<String> viewNames = this.getViewNames(viewName);
        if (viewNames.isEmpty()) {
            throw new BusinessException(String.format("\u6839\u636e\u89c6\u56fe\u540d[%s]\u83b7\u53d6\u4e0d\u5230\u89c6\u56fe", viewName));
        }
        table.setName(viewName);
        table.setComment(viewName);
        table.setColumns(this.getColumns(viewName));
        return table;
    }

    private List<Column> getColumns(String name) {
        String sqlT = "select col.column_name from user_constraints con,user_cons_columns col where con.constraint_name=col.constraint_name and con.constraint_type='P' and col.table_name= ?";
        List listT = this.jdbcTemplate.queryForList(sqlT, new Object[]{name});
        HashSet<String> pkNames = new HashSet<String>();
        for (Map map : listT) {
            pkNames.add(this.getOrDefault(map, "COLUMN_NAME", "").toString());
        }
        String sql = "select a.*,b.comments from user_tab_columns a inner join user_col_comments b on a.table_name = b.table_name and a.column_name = b.column_name and a.table_name = ? ";
        List list = this.jdbcTemplate.queryForList(sql, new Object[]{name});
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Map map : list) {
            Column column = new Column();
            column.setComment(this.getOrDefault(map, "COMMENTS", "").toString());
            Object defVal = map.get("DATA_DEFAULT");
            if (defVal != null && !defVal.toString().trim().equals("NULL")) {
                column.setDefaultValue(map.get("DATA_DEFAULT").toString());
            }
            column.setName(this.getOrDefault(map, "COLUMN_NAME", "").toString());
            column.setPrimary(pkNames.contains(column.getName()));
            column.setRequired("N".equals(this.getOrDefault(map, "NULLABLE", "Y")));
            column.setType(ColumnType.getByDbDataType((String)map.get("DATA_TYPE").toString()).getKey());
            if (ColumnType.VARCHAR.equalsWithKey(column.getType())) {
                column.setLength(Integer.parseInt(this.getOrDefault(map, "DATA_LENGTH", "0").toString()));
            }
            if (ColumnType.NUMBER.equalsWithKey(column.getType())) {
                column.setLength(Integer.parseInt(this.getOrDefault(map, "DATA_PRECISION", "0").toString()));
                column.setDecimal(Integer.parseInt(this.getOrDefault(map, "DATA_SCALE", "0").toString()));
            }
            columns.add(column);
        }
        return columns;
    }

    @Override
    public boolean supportPartition(String tableName) {
        String sql = "select count(*) from user_tab_partitions where table_name = ?";
        Integer rtn = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{tableName});
        return rtn > 0;
    }

    @Override
    public boolean isExsitPartition(String tableName, String partName) {
        String sql = "select count(*) from user_tab_partitions where table_name = ? and partition_name = ?";
        Object[] args = new String[]{tableName, "P_" + partName.toUpperCase()};
        Integer rtn = (Integer)this.jdbcTemplate.queryForObject(sql, args, Integer.class);
        return rtn > 0;
    }

    @Override
    public void createPartition(String tableName, String partName) {
        String sql = "ALTER TABLE " + tableName + " ADD PARTITION P_" + partName.toUpperCase() + " VALUES ( '" + partName + "') NOCOMPRESS ";
        this.jdbcTemplate.update(sql);
    }
}

