/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.dboper;

import com.ailikes.common.form.base.api.constant.ColumnType;
import com.ailikes.common.form.base.api.exception.BusinessException;
import com.ailikes.common.form.base.db.api.table.DbType;
import com.ailikes.common.form.base.db.dboper.DbOperator;
import com.ailikes.common.form.base.db.model.table.Column;
import com.ailikes.common.form.base.db.model.table.Table;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class MysqlDbOperator
extends DbOperator {
    public MysqlDbOperator(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    @Override
    public String type() {
        return DbType.MYSQL.getKey();
    }

    @Override
    public Map<String, String> getTableNames(String tableName) {
        List list;
        String sql = "select table_name,table_comment from information_schema.tables t where t.table_type='BASE TABLE' AND t.table_schema=DATABASE()";
        if (StringUtils.isNotEmpty((CharSequence)tableName)) {
            sql = sql + " AND TABLE_NAME LIKE ?";
            list = this.jdbcTemplate.queryForList(sql, new Object[]{"%" + tableName + "%"});
        } else {
            list = this.jdbcTemplate.queryForList(sql);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map m : list) {
            map.put(m.get("table_name").toString(), m.get("table_comment").toString());
        }
        return map;
    }

    @Override
    public List<String> getViewNames(String viewName) {
        String sql = "show table status where comment='view'";
        if (StringUtils.isNotEmpty((CharSequence)viewName)) {
            sql = sql + " AND NAME LIKE ?";
        }
        ArrayList<String> list = new ArrayList<String>();
        List results = this.jdbcTemplate.queryForList(sql, new Object[]{"%" + viewName + "%"});
        for (Map line : results) {
            list.add(line.get("Name").toString());
        }
        return list;
    }

    @Override
    public Table<Column> getTable(String tableName) {
        Table<Column> table = new Table<Column>();
        Map<String, String> tableNames = this.getTableNames(tableName);
        if (tableNames.isEmpty()) {
            throw new BusinessException(String.format("\u6839\u636e\u8868\u540d[%s]\u83b7\u53d6\u4e0d\u5230\u8868", tableName));
        }
        table.setName(tableName);
        table.setComment(tableNames.get(tableName));
        table.setColumns(this.getColumns(tableName));
        return table;
    }

    @Override
    public Table<Column> getView(String viewName) {
        Table<Column> table = new Table<Column>();
        List<String> viewNames = this.getViewNames(viewName);
        if (viewNames.isEmpty()) {
            throw new BusinessException(String.format("\u6839\u636e\u89c6\u56fe\u540d[%s]\u83b7\u53d6\u4e0d\u5230\u89c6\u56fe", viewName));
        }
        table.setName(viewName);
        table.setComment(viewName);
        table.setColumns(this.getColumns(viewName));
        return table;
    }

    private List<Column> getColumns(String name) {
        String sql = "SELECT * FROM  INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME=?";
        List list = this.jdbcTemplate.queryForList(sql, new Object[]{name});
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Map map : list) {
            Column column = new Column();
            column.setComment(this.getOrDefault(map, "COLUMN_COMMENT", "").toString());
            column.setDefaultValue(map.get("COLUMN_DEFAULT") == null ? null : map.get("COLUMN_DEFAULT").toString());
            column.setName(this.getOrDefault(map, "COLUMN_NAME", "").toString());
            column.setPrimary("PRI".equals(this.getOrDefault(map, "COLUMN_KEY", "")));
            column.setRequired("NO".equals(this.getOrDefault(map, "IS_NULLABLE", "")));
            column.setType(ColumnType.getByDbDataType((String)map.get("DATA_TYPE").toString()).getKey());
            if (ColumnType.VARCHAR.equalsWithKey(column.getType())) {
                column.setLength(Integer.parseInt(this.getOrDefault(map, "CHARACTER_MAXIMUM_LENGTH", "0").toString()));
            }
            if (ColumnType.NUMBER.equalsWithKey(column.getType())) {
                column.setLength(Integer.parseInt(this.getOrDefault(map, "NUMERIC_PRECISION", "0").toString()));
                column.setDecimal(Integer.parseInt(this.getOrDefault(map, "NUMERIC_SCALE", "0").toString()));
            }
            columns.add(column);
        }
        return columns;
    }

    @Override
    public boolean supportPartition(String tableName) {
        String sql = "select count(*) from information_schema.partitions where table_name=?;";
        Integer rtn = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{tableName});
        return rtn > 0;
    }

    @Override
    public boolean isExsitPartition(String tableName, String partName) {
        String sql = "select count(*) from information_schema.partitions where table_name=? and partition_name =?;";
        Object[] args = new String[]{tableName, "P_" + partName.toUpperCase()};
        Integer rtn = (Integer)this.jdbcTemplate.queryForObject(sql, args, Integer.class);
        return rtn > 0;
    }

    @Override
    public void createPartition(String tableName, String partName) {
        String sql = "alter table " + tableName + " add partition (partition P_" + partName.toUpperCase() + " values in ('" + partName + "')) ";
        this.jdbcTemplate.execute(sql);
    }
}

