/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.dboper;

import com.ailikes.common.form.base.core.util.AppUtil;
import com.ailikes.common.form.base.db.api.table.DbType;
import com.ailikes.common.form.base.db.datasource.DbContextHolder;
import com.ailikes.common.form.base.db.dboper.DbOperator;
import com.ailikes.common.form.base.db.dboper.MysqlDbOperator;
import com.ailikes.common.form.base.db.dboper.OracleDbOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbOperatorFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(DbOperatorFactory.class);

    private DbOperatorFactory() {
    }

    public static DbOperator newOperator(String type, JdbcTemplate jdbcTemplate) {
        if (DbType.MYSQL.equalsWithKey(type)) {
            return new MysqlDbOperator(jdbcTemplate);
        }
        if (DbType.ORACLE.equalsWithKey(type)) {
            return new OracleDbOperator(jdbcTemplate);
        }
        LOG.warn("cannot get DbOperator ! DbType:{}", (Object)type);
        return null;
    }

    public static DbOperator getLocal() {
        return DbOperatorFactory.newOperator(DbContextHolder.getDbType(), (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class));
    }
}

