/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.dboper;

import com.ailikes.common.form.base.db.model.table.Column;
import com.ailikes.common.form.base.db.model.table.Table;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class DbOperator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected JdbcTemplate jdbcTemplate;

    public DbOperator(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        if (jdbcTemplate == null) {
            this.logger.warn("create DbOperator with error ! jdbcTemplate cannot be null!");
        }
    }

    public abstract String type();

    public abstract Map<String, String> getTableNames(String var1);

    public abstract List<String> getViewNames(String var1);

    public abstract Table<Column> getTable(String var1);

    public abstract Table<Column> getView(String var1);

    public abstract boolean supportPartition(String var1);

    public abstract boolean isExsitPartition(String var1, String var2);

    public abstract void createPartition(String var1, String var2);

    public Object getOrDefault(Map<?, ?> map, Object key, Object defVal) {
        if (!map.containsKey(key)) {
            return defVal;
        }
        Object val = map.get(key);
        if (val == null) {
            return defVal;
        }
        return val;
    }
}

